% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.hclustering.R
\name{plot.hclustering}
\alias{plot.hclustering}
\title{Plots hierarchical clustering from a 'hclustering' object}
\usage{
\method{plot}{hclustering}(
  x,
  title = NULL,
  profiles = FALSE,
  ncol.arrange = NULL,
  circlize = FALSE,
  horiz = TRUE,
  cex.labels = 0.7,
  colored.labels = TRUE,
  colored.branches = FALSE,
  rect = FALSE,
  lower.rect = NULL,
  min.mid.max = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class \code{hclustering}.}

\item{title}{character or vector of characters (when plotting radial plots of cluster profiles; see Value), plot title(s).}

\item{profiles}{logical; if \code{TRUE}, displays radial plots of cluster profiles (active if \code{x$k} is not \code{NULL}; see Value).}

\item{ncol.arrange}{integer, number of columns when arranging multiple grobs on a page (active when plotting radial plots of cluster profiles; see Value).}

\item{circlize}{logical; if \code{TRUE}, plots a circular dendrogram (active when plotting a dendrogram; see Value).}

\item{horiz}{logical; if \code{TRUE}, plots an horizontal dendrogram (active when plotting a non circular dendrogram; see Value).}

\item{cex.labels}{numeric, the magnification to be used for labels (active when plotting a dendrogram; see Value).}

\item{colored.labels}{logical; if \code{TRUE}, assigns different colors to labels of different clusters (active when plotting a dendrogram; see Value).}

\item{colored.branches}{logical; if \code{TRUE}, assigns different colors to branches of different clusters (active when plotting a dendrogram; see Value).}

\item{rect}{logical; if \code{TRUE}, draws rectangles around the branches in order to highlight the corresponding clusters (active when plotting a dendrogram; see Value).}

\item{lower.rect}{numeric, a value of how low should the lower part of the rect be (active when plotting a dendrogram; see option \code{lower_rect} of \code{\link[dendextend]{rect.dendrogram}}).}

\item{min.mid.max}{numeric vector with 3 elements: lower bound, middle dashed line, upper bound for radial axis (active when plotting radial plots of cluster profiles; see Value).}

\item{...}{other graphical parameters.}
}
\value{
If \code{x$k} is \code{NULL}, \code{plot.hclustering} returns a single \code{ggplot2} object, displaying the pattern of the explained variance vs the number of clusters.

If \code{x$k} is not \code{NULL} and \code{profiles=FALSE}, \code{plot.hclustering} returns a single \code{ggplot2} object, displaying the dendrogram.

If \code{x$k} is not \code{NULL} and \code{profiles=TRUE}, \code{plot.hclustering} returns a list of \code{ggplot2} objects, displaying the radial plots of the cluster profiles.
}
\description{
Plots hierarchical clustering from a 'hclustering' object
}
\examples{
data <- with(Pbox, data.frame(PTS, P3M, REB=OREB+DREB, AST, TOV, STL, BLK, PF))
data <- subset(data, Pbox$MIN >= 1500)
ID <- Pbox$Player[Pbox$MIN >= 1500]
hclu1 <- hclustering(data)
plot(hclu1)
hclu2 <- hclustering(data, labels=ID, k=7)
plot(hclu2)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{hclustering}}, \code{\link{radialprofile}}.
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
