% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_fun.R
\name{loss_fun}
\alias{loss_fun}
\title{Loss Function for Fitting the BKP Model}
\usage{
loss_fun(
  gamma,
  Xnorm,
  y,
  m,
  prior = c("noninformative", "fixed", "adaptive"),
  r0 = 2,
  p0 = 0.5,
  loss = c("brier", "log_loss"),
  kernel = c("gaussian", "matern52", "matern32")
)
}
\arguments{
\item{gamma}{A numeric vector of log-transformed kernel hyperparameters.}

\item{Xnorm}{A numeric matrix of normalized inputs (each column scaled to
\code{[0,1]}).}

\item{y}{A numeric vector of observed successes (length \code{n}).}

\item{m}{A numeric vector of total binomial trials (length \code{n}),
corresponding to each \code{y}.}

\item{prior}{Type of prior to use. One of \code{"noninformative"},
\code{"fixed"}, or \code{"adaptive"}.}

\item{r0}{Global prior precision (only used when \code{prior = "fixed"} or
\code{"adaptive"}).}

\item{p0}{Global prior mean (only used when \code{prior = "fixed"}).}

\item{loss}{Loss function for kernel hyperparameter tuning. One of
\code{"brier"} (default) or \code{"log_loss"}.}

\item{kernel}{Kernel function for local weighting. Choose from
\code{"gaussian"}, \code{"matern52"}, or \code{"matern32"}.}
}
\value{
A single numeric value representing the total loss (to be minimized).
}
\description{
Computes the loss used to fit the BKP model. Supports the Brier
score (mean squared error) and negative log-loss (cross-entropy), under
different prior specifications.
}
\examples{
set.seed(123)
n = 10
Xnorm = matrix(runif(2 * n), ncol = 2)
m = rep(10, n)
y = rbinom(n, size = m, prob = runif(n))
loss_fun(gamma = rep(0, 2), Xnorm = Xnorm, y = y, m = m)

}
\seealso{
\code{\link{loss_fun_dkp}}, \code{\link{fit.BKP}}, \code{\link{get_prior}},
\code{\link{kernel_matrix}}
}
