% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geTree.R
\name{generateCDT}
\alias{generateCDT}
\title{Generates a complete derivation tree from an integer vector.}
\usage{
generateCDT(sym, kvec, complete = TRUE, G, maxdepth = 5)
}
\arguments{
\item{sym}{Non-terminal symbol.}

\item{kvec}{Integer vector.}

\item{complete}{Boolean. FALSE for incomplete derivation trees.}

\item{G}{Grammar.}

\item{maxdepth}{Integer. Maximal depth of the derivation tree.}
}
\value{
A named list l$tree, l$kvec, l$complete.
}
\description{
\code{generateCDT()} 
   generates a derivation tree from an integer vector.
   The derivation tree may be incomplete.
   (For grammatical evolution).
}
\details{
\code{generateDerivationTree()} recursively expands 
        non-terminals and builds a derivation tree.
}
\examples{
g<-compileBNF(booleanGrammar())
a<-sample(100, 100, replace=TRUE)
b<-generateCDT(sym=g$Start, kvec=a, G=g, maxdepth=10)
decodeDT(b$tree, g$ST)

}
\seealso{
Other Generate Derivation Tree: 
\code{\link{generateDerivationTree}()},
\code{\link{randomDerivationTree}()},
\code{\link{rndsub}()},
\code{\link{rndsubk}()},
\code{\link{substituteSymbol}()}
}
\concept{Generate Derivation Tree}
