% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{aggregate_to_timeseries}
\alias{aggregate_to_timeseries}
\title{Create Time-Series Aggregated Data}
\usage{
aggregate_to_timeseries(panel_data, vars = c("log_direct", "log_production"))
}
\arguments{
\item{panel_data}{Data frame with panel data.}

\item{vars}{Character vector of variables to aggregate.
Default c("log_direct", "log_production").}
}
\value{
Data frame with one row per year containing aggregated values.
}
\description{
Aggregates panel data to time series by computing means across sectors.
}
\examples{
set.seed(123)
panel <- data.frame(
  year = rep(2000:2005, 3),
  sector = rep(c("A", "B", "C"), each = 6),
  log_direct = rnorm(18, mean = 5),
  log_production = rnorm(18, mean = 5)
)
ts_agg <- aggregate_to_timeseries(panel)
head(ts_agg)

}
