% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coh_match_utils.R
\name{match_cohort_}
\alias{match_cohort_}
\title{Match Cohort Using Mahalanobis Distance}
\usage{
match_cohort_(data_set, vacc_status_col, exact = NULL, nearest = NULL)
}
\arguments{
\item{data_set}{\code{data.frame} with cohort information.}

\item{vacc_status_col}{Name of the column containing the vaccination.}

\item{exact}{Name(s) of column(s) for \code{exact} matching}

\item{nearest}{Named vector with name(s) of column(s) for \code{nearest} matching
and caliper(s) for each variable (e.g., \code{nearest = c("characteristic1" = n1, "characteristic2" = n2)}, where \code{n1} and \code{n2} are the calipers).}
}
\value{
\code{data.frame} with the matched population.
}
\description{
This function constructs pairs of vaccinated and unvaccinated
individuals with similar characteristics. It relies on the matching
algorithm implemented in the package \code{{MatchIt}}.
By default, the function uses \code{method = "nearest"}, \code{ratio = 1}, and
\code{distance = "mahalanobis"} to perform the matching.
}
\keyword{internal}
