% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coh_match.R
\name{match_cohort}
\alias{match_cohort}
\title{Match Cohort to Reduce Observational Bias}
\usage{
match_cohort(
  data_set,
  outcome_date_col,
  censoring_date_col,
  start_cohort,
  end_cohort,
  nearest,
  exact,
  immunization_date_col,
  vacc_status_col,
  vaccinated_status,
  unvaccinated_status
)
}
\arguments{
\item{data_set}{\code{data.frame} with cohort information.}

\item{outcome_date_col}{Name of the column that contains the outcome dates.}

\item{censoring_date_col}{Name of the column that contains the censoring
date.}

\item{start_cohort}{Start date of the study.}

\item{end_cohort}{End date of the study.}

\item{nearest}{Named vector with name(s) of column(s) for \code{nearest} matching
and caliper(s) for each variable (e.g., \code{nearest = c("characteristic1" = n1, "characteristic2" = n2)}, where \code{n1} and \code{n2} are the calipers).}

\item{exact}{Name(s) of column(s) for \code{exact} matching}

\item{immunization_date_col}{Name of the column that contains the
immunization date to set the beginning of the follow-up period
(\code{t0_follow_up}).}

\item{vacc_status_col}{Name of the column containing the vaccination.}

\item{vaccinated_status}{Status assigned to the vaccinated population.}

\item{unvaccinated_status}{Status assigned to the unvaccinated population.}
}
\value{
object of the class \code{match}. List with results from static match:
\code{match}: \code{data.frame} with adjusted cohort,
\code{summary}: matching summary,
\code{balance_all}: balance of the cohort before matching,
\code{balance_matched}: balance of the cohort after matching.

Four columns are added to the structure provided in \code{data_set}:
\code{subclass}: ID of, matched pair,
\code{t0_follow_up}: beginning of follow-up period for pair,
\code{time_to_event}: time to event,
and \code{outcome_status}: outcome status
(1:positive, 0: negative).
}
\description{
This function builds pairs of vaccinated and unvaccinated
individuals with similar characteristics. The function relies on the matching
algorithm implemented in the package \code{{MatchIt}}, setting, by default,
\code{method = "nearest"}, \code{ratio = 1}, and \code{distance = "mahalanobis"}.
Exact and near characteristics are accepted, passed in the parameters \code{exact}
and \code{nearest}, respectively. The parameter \code{nearest} must be provided
together with the calipers as a named vector (e.g.,
\code{nearest = c(characteristic1 = n1, characteristic2 = n2)}, where \code{n1}
and \code{n2} are the calipers). The default matching \code{method} of the function is
\code{static}. This means that pairs are matched once, without taking into
account their vaccination, censoring, and outcome dates. After this, the
pairs whose exposure time do not coincide are removed to avoid negative
time-to-events.
The function returns a matched and adjusted by exposure cohort, with
information of the beginning of follow-up period of pairs (\code{t0_follow_up}),
corresponding to the vaccination date of the vaccinated individual, the
individual time-to-event (\code{time_to_event}) and the outcome status
(\code{outcome_status}), both taking into account the right-censoring dates.
Pairs are censored if the vaccinated or unvaccinated partner was previously
censored (i.e., if \code{censoring_date_col} is informed) and the censor occurs
before their outcomes. Rolling calendar matching method will be included in
future releases.
}
\keyword{internal}
