% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_set_data_variance_check}
\alias{umx_set_data_variance_check}
\title{umx_set_data_variance_check}
\usage{
umx_set_data_variance_check(minVar = NULL, maxVarRatio = NULL, silent = FALSE)
}
\arguments{
\item{minVar}{Set the threshold at which to warn user about variables with too-small variance. Else returns the current value of umx_minVar}

\item{maxVarRatio}{Set the option for threshold at which to warn user variances differ too much. Else returns the current value of umx_maxVarRatio}

\item{silent}{If TRUE, no message will be printed.}
}
\value{
- list of umx_minVar and umx_maxVarRatio settings
}
\description{
Set default for data checking in models like umxACE umxGxE etc.
}
\examples{
library(umx)
umx_set_data_variance_check() # print current state
old = umx_set_data_variance_check(silent = TRUE) # store existing value
umx_set_data_variance_check(minVar = .01)
umx_set_data_variance_check(maxVarRatio = 500)
umx_set_data_variance_check(minVar = old$minVar, maxVarRatio = old$maxVarRatio) # reinstate
}
\seealso{
xmu_check_variance which uses these to check sanity in the variances of a data frame.

Other Get and set: 
\code{\link{umx}},
\code{\link{umx_get_alphas}()},
\code{\link{umx_get_checkpoint}()},
\code{\link{umx_get_options}()},
\code{\link{umx_set_auto_plot}()},
\code{\link{umx_set_auto_run}()},
\code{\link{umx_set_checkpoint}()},
\code{\link{umx_set_condensed_slots}()},
\code{\link{umx_set_cores}()},
\code{\link{umx_set_dollar_symbol}()},
\code{\link{umx_set_optimization_options}()},
\code{\link{umx_set_optimizer}()},
\code{\link{umx_set_plot_file_suffix}()},
\code{\link{umx_set_plot_format}()},
\code{\link{umx_set_separator}()},
\code{\link{umx_set_silent}()},
\code{\link{umx_set_table_format}()}
}
\concept{Get and set}
