% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoCoprimary2MixedContinuousBinary.R
\name{twoCoprimary2MixedContinuousBinary}
\alias{twoCoprimary2MixedContinuousBinary}
\title{Unified Interface for Mixed Continuous and Binary Co-Primary Endpoints}
\usage{
twoCoprimary2MixedContinuousBinary(
  n1 = NULL,
  n2 = NULL,
  delta,
  sd,
  p1,
  p2,
  rho,
  power = NULL,
  r = NULL,
  alpha = 0.025,
  Test = "AN",
  nMC = 10000
)
}
\arguments{
\item{n1}{Sample size for group 1 (treatment group). If NULL, will be calculated.}

\item{n2}{Sample size for group 2 (control group). If NULL, will be calculated.}

\item{delta}{Mean difference for the continuous endpoint}

\item{sd}{Common standard deviation for the continuous endpoint}

\item{p1}{True response probability for the binary endpoint in group 1}

\item{p2}{True response probability for the binary endpoint in group 2}

\item{rho}{Biserial correlation between the continuous endpoint and the
latent continuous variable underlying the binary endpoint}

\item{power}{Target power (1 - beta). If NULL, will be calculated.}

\item{r}{Allocation ratio (n1/n2). Required when calculating sample size.}

\item{alpha}{One-sided significance level (typically 0.025 or 0.05)}

\item{Test}{Test method for the binary endpoint: "AN" (asymptotic normal),
"ANc" (with continuity correction), "AS" (arcsine), "ASc" (arcsine with
continuity correction), or "Fisher" (Fisher's exact test)}

\item{nMC}{Number of Monte Carlo simulations when Test = "Fisher".
Default is 10000.}
}
\value{
An object of class "twoCoprimary" containing either:
\itemize{
\item Power calculation results (when n1 and n2 are specified)
\item Sample size calculation results (when power and r are specified)
}
}
\description{
This function provides a unified interface for both power calculation and
sample size determination for trials with one continuous and one binary
co-primary endpoint.
}
\details{
This function serves as a unified interface similar to \code{power.prop.test()}.
The function determines the operation mode based on which parameters are NULL.

Exactly one of \{(n1, n2), (power, r)\} must be NULL.

The biserial correlation rho represents the correlation between the observed
continuous endpoint and the latent continuous variable underlying the binary
endpoint.
}
\examples{
# Calculate power given sample sizes
twoCoprimary2MixedContinuousBinary(
  n1 = 100, n2 = 100,
  delta = 0.5, sd = 1,
  p1 = 0.6, p2 = 0.4,
  rho = 0.5,
  alpha = 0.025, Test = "AN"
)

# Calculate sample size given target power
twoCoprimary2MixedContinuousBinary(
  delta = 0.5, sd = 1,
  p1 = 0.6, p2 = 0.4,
  rho = 0.5,
  power = 0.8, r = 1,
  alpha = 0.025, Test = "AN"
)

}
