% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_serialise.R
\name{loso}
\alias{loso}
\title{Lists of serialisable objects}
\usage{
loso(..., count = NA)
}
\arguments{
\item{...}{List elements.}

\item{count}{If only one element is provided, an optional integer specifying
the number of times to repeat the element. This allows lists of a fixed
size to be created using a default value.}
}
\value{
A list of class \code{"loso"}.
}
\description{
This function creates objects of S3 class \code{"loso"}, which are standard
lists with this class attribute set. These objects can be used within
\code{\linkS4class{SerialisableObject}} objects for fields that contain
multiple objects which may themselves be serialisable. Otherwise their
functionality is the same as a normal list.
}
\note{
TractoR's serialisable objects are reference classes, and so naive use
  of \code{\link{rep}} to create a list of object copies will have reference
  semantics whereby each object refers to the same set of fields, which is
  rarely the intention. This function explicitly creates a deep copy for
  each replicate to avoid this.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\seealso{
\code{\linkS4class{SerialisableObject}}, \code{\link{save}},
\code{\link{load}}, \code{\link{writeImageFile}}.
}
\author{
Jon Clayden
}
