% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synth_spec.R
\name{synth_spec}
\alias{synth_spec}
\title{Create a \code{synth_spec} object}
\usage{
synth_spec(
  default_regression_model = NULL,
  default_classification_model = NULL,
  custom_models = NULL,
  default_regression_steps = NULL,
  default_classification_steps = NULL,
  custom_steps = NULL,
  default_regression_sampler = NULL,
  default_classification_sampler = NULL,
  custom_samplers = NULL,
  default_regression_noise = NULL,
  default_classification_noise = NULL,
  custom_noise = NULL,
  default_regression_tuner = NULL,
  default_classification_tuner = NULL,
  custom_tuners = NULL,
  default_extractor = NULL,
  custom_extractors = NULL,
  invert_transformations = TRUE,
  enforce_na = TRUE
)
}
\arguments{
\item{default_regression_model}{A \code{model_spec} object from \code{library(parsnip)}
for use in regression models.}

\item{default_classification_model}{A \code{model_spec} object from \code{library(parsnip)}
for use in classification models.}

\item{custom_models}{A list of named lists each with two elements:
\code{vars} for variable names, and \code{model} for their associated model.
from \code{library(parsnip)}.}

\item{default_regression_steps}{A list of \code{recipe::step_} function(s)
from \code{library(recipes)} for use in regression models.}

\item{default_classification_steps}{A list of \code{recipe::step_} function(s)
from \code{library(recipes)} for use in classification models.}

\item{custom_steps}{A list of named lists each with two elements:
\code{vars} for variable names, and \code{steps} for their associated recipe.}

\item{default_regression_sampler}{A sampling function for drawing
new values from regression models.}

\item{default_classification_sampler}{A sampling function for drawing
new values from classification models.}

\item{custom_samplers}{A list of named lists each with two elements:
\code{vars} for variable names, and \code{sampler} for their associated sampler}

\item{default_regression_noise}{A noise function for adding noise to numeric
values.}

\item{default_classification_noise}{A noise function for adding noise to
classification values.}

\item{custom_noise}{A list of named lists each with two elements:
\code{vars} for variable names, and \code{noise} for their associated noise}

\item{default_regression_tuner}{A \code{tuner} from \code{library(tune)}
for use in regression models.}

\item{default_classification_tuner}{A \code{tuner} from \code{library(tune)}
for use in classification models.}

\item{custom_tuners}{A list of named lists each with two elements:
\code{vars} for variable names, and \code{tuner} for their associated tuner}

\item{default_extractor}{An optional method for extracting workflows or
extracts from workflows.}

\item{custom_extractors}{A list of named lists each with two elements:
\code{vars} for variable names, and \code{extractor} for their associated extractor}

\item{invert_transformations}{A Boolean for if outcome variable
transformations applied through recipes should be inverted during synthesis.
recipes need ids that begin with "outcome".}

\item{enforce_na}{A Boolean for if NA values should be added into the
synthetic data with \code{enforce_na()} during synthesis. An alternative approach
is to add the NA values after synthesis}
}
\value{
A \code{synth_spec} object
}
\description{
The \code{synth_spec} object holds specifications for modeling and sampling components
for sequential synthetic data generation. Each component has an associated
\verb{construct_*} function called when creating a \code{presynth} object.
}
\examples{

rpart_mod <- parsnip::decision_tree() |>
  parsnip::set_engine(engine = "rpart") |>
  parsnip::set_mode(mode = "regression")

lm_mod <- parsnip::linear_reg() |> 
  parsnip::set_engine("lm") |>
  parsnip::set_mode(mode = "regression")

step1 <- function(x) {
 x |>
   recipes::step_center(recipes::all_predictors(), id = "center")
}

step2 <- function(x) {
  x |>
    recipes::step_scale(recipes::all_predictors(), id = "scale")
}

step3 <- function(x) { x |> step1() |> step2() }


synth_spec(
 default_regression_model = rpart_mod,
 custom_models = list(
   list("vars" = c("var1", "var2"), 
        "model" = lm_mod)
 ),
 default_regression_steps = step1,
 custom_steps = list(
   list("vars" = c("var2", "var3"),
        "steps" = step2),
   list("vars" = c("var4"), 
        "steps" = step3)
 ),
 default_regression_sampler = sample_rpart,
 custom_samplers = list(
   list("vars" = c("var1", "var2"), 
        "sampler" = sample_lm)
 )
)

}
