% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_save.R
\name{gt_save}
\alias{gt_save}
\title{Save a gen_tibble}
\usage{
gt_save(x, file_name = NULL, quiet = FALSE)
}
\arguments{
\item{x}{a \code{\link{gen_tibble}}}

\item{file_name}{the file name, including the full path. If it does not end
with \emph{.gt}, the extension will be added.}

\item{quiet}{boolean to suppress information about the files}
}
\value{
the file name and path of the \emph{.gt} file, together with the \emph{.rds}
and \emph{.bk} files
}
\description{
Save the tibble (and update the backing files). The \code{gen_tibble} object is
saved to a file with extension \emph{.gt}, together with update its \emph{.rds} and
\emph{.bk} files. Note that multiple \emph{.gt} files can be linked to the same \emph{.rds}
and \emph{.bk} files; generally, this occurs when we create multiple subsets of
the data. The \emph{.gt} file then stores the information on what subset of the
full dataset we are interested in, whilst the \emph{.rds} and \emph{.bk} file store the
full dataset. To reload a \code{gen_tibble}, you can pass the name of the \emph{.gt}
file with \code{\link[=gt_load]{gt_load()}}.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# remove some individuals
example_gt <- example_gt \%>\% filter(id != "a")

# save filtered gen_tibble object
gt_save(example_gt, file_name = paste0(tempfile(), "_example_filtered"))

}
\seealso{
\code{\link[=gt_load]{gt_load()}}
}
