% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_has_imputed.R
\name{gt_set_imputed}
\alias{gt_set_imputed}
\title{Sets a \code{gen_tibble} to use imputed data}
\usage{
gt_set_imputed(x, set = NULL)
}
\arguments{
\item{x}{a \code{gen_tibble}}

\item{set}{a boolean defining whether imputed data should be used}
}
\value{
the gen_tibble, invisibly
}
\description{
This function sets or unsets the use of imputed data. For some analysis,
such as PCA, that does not allow for missing data, we have to use imputation,
but for other analysis it might be preferable to allow for missing data.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# Impute the gen_tibble
example_gt <- example_gt \%>\% gt_impute_simple()

# Check whether the gen_tibble uses imputed values
example_gt \%>\% gt_uses_imputed()

# Set the gen_tibble to use imputed values
example_gt \%>\% gt_set_imputed(TRUE)

# And check that the gen_tibble uses imputed values again
example_gt \%>\% gt_uses_imputed()
}
