% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbind_gen_tibble.R
\name{cbind.gen_tbl}
\alias{cbind.gen_tbl}
\title{Combine a gen_tibble to a data.frame or tibble by column}
\usage{
\method{cbind}{gen_tbl}(..., deparse.level = 1)
}
\arguments{
\item{...}{a gen_tibble and a data.frame or tibble}

\item{deparse.level}{an integer controlling the construction of column names.
See \code{\link[base]{cbind}} for details.}
}
\value{
a \code{gen_tibble}
}
\description{
A \code{\link[=cbind]{cbind()}} method to merge \code{gen_tibble} objects with data.frames and normal
tibbles. Whilst this works, it is not ideal as it does not check the order of
the tables, and we suggest that you use \code{\link[dplyr:mutate-joins]{dplyr::left_join()}} instead. Note
that \code{cbind} will not combine two \code{gen_tibbles} (i.e. it will NOT combine
markers for the same individuals)
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# Create a dataframe to combine with the gen_tibble
df <- data.frame(region = c("A", "A", "B", "B", "A", "B", "B"))

# Combine the gen_tibble with the dataframe
example_gt <- cbind(example_gt, df)
}
