#' Fail if any tests fail
#'
#' This reporter will simply throw an error if any of the tests failed. It is
#' best combined with another reporter, such as the
#' [SummaryReporter].
#'
#' @export
#' @family reporters
FailReporter <- R6::R6Class(
  "FailReporter",
  inherit = Reporter,
  public = list(
    failed = FALSE,

    initialize = function(...) {
      self$capabilities$parallel_support <- TRUE
      super$initialize(...)
    },

    add_result = function(context, test, result) {
      self$failed <- self$failed || expectation_broken(result)
    },

    end_reporter = function() {
      if (self$failed) {
        cli::cli_abort("Failures detected.")
      }
    }
  )
)
