% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_ci.R
\name{tm_g_ci}
\alias{tm_g_ci}
\title{teal Module: Confidence Interval Plot}
\usage{
tm_g_ci(
  label,
  x_var,
  y_var,
  color,
  stat = c("mean", "median"),
  conf_level = teal.transform::choices_selected(c(0.95, 0.9, 0.8), 0.95, keep_order =
    TRUE),
  plot_height = c(700L, 200L, 2000L),
  plot_width = NULL,
  pre_output = NULL,
  post_output = NULL,
  ggplot2_args = teal.widgets::ggplot2_args(),
  transformators = list(),
  decorators = list()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{x_var}{(\code{character})\cr name of the treatment variable to put on the x-axis.}

\item{y_var}{(\code{character})\cr name of the response variable to put on the y-axis.}

\item{color}{(\code{data_extract_spec})\cr the group variable used to determine the plot colors, shapes, and line types.}

\item{stat}{(\code{character})\cr statistic to plot. Options are \code{"mean"} and \code{"median"}.}

\item{conf_level}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and pre-selected option for the confidence level, each within range of (0, 1).}

\item{plot_height}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the
height of the main plot and renders a slider on the plot to interactively adjust the plot height.}

\item{plot_width}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the width
of the main plot and renders a slider on the plot to interactively adjust the plot width.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{ggplot2_args}{(\code{ggplot2_args}) optional\cr object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings
for the module plot. The argument is merged with option \code{teal.ggplot2_args} and with default module arguments
(hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}

\item{transformators}{(\code{list} of \code{teal_transform_module}) that will be applied to transform module's data input.
To learn more check \code{vignette("transform-input-data", package = "teal")}.}

\item{decorators}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
(named \code{list} of lists of \code{teal_transform_module}) optional,
decorator for tables or plots included in the module output reported.
The decorators are applied to the respective output objects.

See section "Decorating Module" below for more details.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} type confidence interval plot consistent with the TLG Catalog template
\code{CIG01} available \href{https://insightsengineering.github.io/tlg-catalog/stable/graphs/other/cig01.html}{here}.
}
\section{Decorating Module}{


This module generates the following objects, which can be modified in place using decorators:
\itemize{
\item \code{plot} (\code{ggplot})
}

A Decorator is applied to the specific output using a named list of \code{teal_transform_module} objects.
The name of this list corresponds to the name of the output to which the decorator is applied.
See code snippet below:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tm_g_ci(
   ..., # arguments for module
   decorators = list(
     plot = teal_transform_module(...) # applied only to `plot` output
   )
)
}\if{html}{\out{</div>}}

For additional details and examples of decorators, refer to the vignette
\code{vignette("decorate-module-output", package = "teal.modules.clinical")}.

To learn more please refer to the vignette
\code{vignette("transform-module-output", package = "teal")} or the \code{\link[teal:teal_transform_module]{teal::teal_transform_module()}} documentation.
}

\section{Reporting}{



This module returns an object of class \code{teal_module}, that contains a \code{server} function.
Since the server function returns a \code{teal_report} object, this makes this module reportable, which means that
the reporting functionality will be turned on automatically by the \code{teal} framework.

For more information on reporting in \code{teal}, see the vignettes:
\itemize{
\item \code{vignette("reportable-shiny-application", package = "teal.reporter")}
\item \code{vignette("adding-support-for-reporting-to-custom-modules", package = "teal")}
}

}

\examples{
library(nestcolor)

data <- teal_data()
data <- within(data, {
  library(teal.modules.clinical)
  library(dplyr)
  ADSL <- tmc_ex_adsl
  ADLB <- tmc_ex_adlb
})
join_keys(data) <- default_cdisc_join_keys[names(data)]

ADSL <- data[["ADSL"]]
ADLB <- data[["ADLB"]]

app <- init(
  data = data,
  modules = modules(
    tm_g_ci(
      label = "Confidence Interval Plot",
      x_var = data_extract_spec(
        dataname = "ADSL",
        select = select_spec(
          choices = c("ARMCD", "BMRKR2"),
          selected = c("ARMCD"),
          multiple = FALSE,
          fixed = FALSE
        )
      ),
      y_var = data_extract_spec(
        dataname = "ADLB",
        filter = list(
          filter_spec(
            vars = "PARAMCD",
            choices = levels(ADLB$PARAMCD),
            selected = levels(ADLB$PARAMCD)[1],
            multiple = FALSE,
            label = "Select lab:"
          ),
          filter_spec(
            vars = "AVISIT",
            choices = levels(ADLB$AVISIT),
            selected = levels(ADLB$AVISIT)[1],
            multiple = FALSE,
            label = "Select visit:"
          )
        ),
        select = select_spec(
          label = "Analyzed Value",
          choices = c("AVAL", "CHG"),
          selected = "AVAL",
          multiple = FALSE,
          fixed = FALSE
        )
      ),
      color = data_extract_spec(
        dataname = "ADSL",
        select = select_spec(
          label = "Color by variable",
          choices = c("SEX", "STRATA1", "STRATA2"),
          selected = c("STRATA1"),
          multiple = FALSE,
          fixed = FALSE
        )
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
The \href{https://insightsengineering.github.io/tlg-catalog/stable/}{TLG Catalog} where additional example
apps implementing this module can be found.
}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQSvxQpFD6RlzUAPqh4dYhYRGGOgDutKQAFrQQ7PFQuDogSjo67sxsnHDcvALCYhJSMvKl5QyVHPyo1KyBbQCCACIAygAykTqkMAQxcAAeMVD8otSDQ2MAQpPTswtL-NT0SgC+QQBWRLkxANZwrKL5yTap-HDGUMKkMQT8tKKzS7XO4PYDQeCPApyAC6rggw3GkwKwGACjACLGaOhsPhG22r2SKLRwy2WJxSjQqEmuUy7DaBR0AF4dAVcG0+EIRKImToOQ1Hm0ytMYgBzH60OkQMrS8pQehwag8tEAYRIxlob3MugAkipGJpuDoAAr+UhotlSmU6RYGxg8gpzeakNTfUSoOAESVW6UFcG6ZnE0aYvCCq2iBUe0g88MidQxN0er3e6UELJXAhiHme4lYACyyqG5p0aM2uawAGksAAmNFyC3J6UxyNwfhZunovMF2v1hu8r60Hr+nQAMQGYxGTh7DfV8xbPNH45clu9QRXU+lrBitvtyUdzqgcYT2eXVt9sCHgdJIZPMvV1HIduZdFEpCT09o99U8fdx970tt3IBmARoDFgAz5oW15-mUqbppmT5wNo1CPCSmwACQgWBEF1qGDZNuoc4IUhKF4hhoHgQWcjAAAjNC64NjA-aDvOY4TvRybUHKCpKmAIwRuosr0IgaK4VaOE3lad4Pt+iaid6AE8QMABq2ojNqtjmnJVqwTI8HlIhCokVsaHKap6nidBOj4eQrZEYZ7CoSZKlqbYVG0ex3qMfeA4iCxi4eVanHyoqQF8bGUaaP8mTCWAWllKuyYWcm1nRvxro-m+HFcSFxbotAvQAF5zkp3CCHAmkSTKOkZoBOjZuiSljkWKoABIAOLdnFVlpYRuXKU1UG9l5GjMcyC5sV1M69eNS4NglMpJVVRD+I+LK7gs+6HhlWlnvAilBhVeFpal4Uyb+vZBdxQGqitOj0KwOi2rQcoiIdvbVXp9UTgAGs1vH2AMtgDNRf0jADQM1mAi3JT1tl1e2YNgUDINQwFZTDT5Q4zWjJi0LOcMzVp83SsTCVBEEtDGDo7C5A+B4aNo1g2CUlqiDkECsAM6DsJSaGCLQRS8+G+qqEEJxKGAJzQkAA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQSvxQpFD6RlzUAPqh4dYhYRGGOgDutKQAFrQQ7PFQuDogSjo67sxsnHDcvALCYhJSMvKl5QyVHPyo1KyBbQCCACIAygAykTqkMAQxcAAeMVD8otSDQ2MAQpPTswtL-NT0SgC+QQBWRLkxANZwrKL5yTap-HDGUMKkMQT8tKKzS7XO4PYDQeCPApyAC6rggw3GkwKwGACjACLGaOhsPhG22r2SKLRwy2WJxSjQqEmuUy7DaBR0AF4dAVcG0+EIRKImToOQ1Hm0ytMYgBzH60OkQMrS8pQehwag8tEAYRIxlob3MugAkipGJpuDoAAr+UhotlSmU6RYGxg8gpzeakNTfUSoOAESVW6UFcG6ZnE0aYvCCq2iBUe0g88MidQxN0er3e6UELJXAhiHme4lYACyyqG5p0aM2uawAGksAAmNFyC3J6UxyNwfhZunovMF2v1hu8r60Hr+nQAMQGYxGTh7DfV8xbPNH45clu9QRXU+lrBitvtyUdzqgcYT2eXVt9sCHgdJIZPMvV1HIduZdFEpCT09o99U8fdx970tt3IBmARoDFgAz5oW15-mUqbppmT5wNo1CPCSmwACQgWBEF1qGDZNuoc4IUhKF4hhoHgQWcjAAAjNC64NjA-aDvOY4TvRybUHKCpKmAIwRuosr0IgaK4VaOE3lad4Pt+iaid6AE8QMABq2ojNqtjmnJVqwTI8HlIhCokVsaHKap6nidBOj4eQrZEYZ7CoSZKlqbYVG0ex3qMfeA4iCxi4eVanHyoqQF8bGUaaP8mTCWAWllKuyYWcm1nRvxro-m+HFcSFxbotAvQAF5zkp3CCHAmkSTKOkZoBOjZuiSljkWKoABIAOLdnFVlpYRuXKU1UG9l5GjMcyC5sV1M69eNS4NglMpJVVRD+I+LK7gs+6HhlWlnvAilBhVeFpal4Uyb+vZBdxQGqitOj0KwOi2rQcoiIdvbVXp9UTgAGs1vH2AMtgDNRf0jADQM1mAi3JT1tl1e2YNgUDINQwFZTDT5Q4zWjJi0LOcMzVp83SsTCVBEEtDGDo7C5A+B4aNo1g2CUlqiDkECsAM6DsJSaGCLQRS8+G+qqEEJxKGAJzQkAA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

