% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{lbl_discrete}
\alias{lbl_discrete}
\title{Label discrete data}
\usage{
lbl_discrete(
  symbol = em_dash(),
  unit = 1L,
  fmt = NULL,
  single = NULL,
  first = NULL,
  last = NULL
)
}
\arguments{
\item{symbol}{String: symbol to use for the dash.}

\item{unit}{Minimum difference between distinct values of data.
For integers, 1.}

\item{fmt}{String, list or function. A format for break endpoints.}

\item{single}{Glue string: label for singleton intervals. See \code{\link[=lbl_glue]{lbl_glue()}}
for details. If \code{NULL}, singleton intervals will be labelled the same way
as other intervals.}

\item{first}{Glue string: override label for the first category. Write e.g.
\code{first = "<{r}"} to create a label like \code{"<18"}. See \code{\link[=lbl_glue]{lbl_glue()}}
for details.}

\item{last}{String: override label for the last category. Write e.g.
\code{last = ">{l}"} to create a label like \code{">65"}. See \code{\link[=lbl_glue]{lbl_glue()}}
for details.}
}
\value{
A function that creates a vector of labels.
}
\description{
\code{lbl_discrete()} creates labels for discrete data, such as integers.
For example, breaks
\code{c(1, 3, 4, 6, 7)} are labelled: \verb{"1-2", "3", "4-5", "6-7"}.
}
\details{
No check is done that the data are discrete-valued. If they are not, then
these labels may be misleading. Here, discrete-valued means that if
\code{x < y}, then \code{x <= y - unit}.

Be aware that Date objects may have non-integer values. See \link{Date}.
}
\section{Formatting endpoints}{


If \code{fmt} is not \code{NULL} then it is used to format the endpoints.
\itemize{
\item If \code{fmt} is a string, then numeric endpoints will be formatted by
\code{sprintf(fmt, breaks)}; other endpoints, e.g. \link{Date} objects, will be
formatted by \code{format(breaks, fmt)}.
\item If \code{fmt} is a list, then it will be used as arguments to \link{format}.
\item If \code{fmt} is a function, it should take a vector of numbers (or other objects
that can be used as breaks) and return a character vector. It may be helpful
to use functions from the \code{{scales}} package, e.g. \code{\link[scales:label_number]{scales::label_comma()}}.
}
}

\examples{
tab(1:7, c(1, 3, 5), lbl_discrete())

tab(1:7, c(3, 5), lbl_discrete(first = "<= {r}"))

tab(1:7 * 1000, c(1, 3, 5) * 1000, lbl_discrete(unit = 1000))

# Misleading labels for non-integer data
chop(2.5, c(1, 3, 5), lbl_discrete())

}
\seealso{
Other labelling functions: 
\code{\link{lbl_dash}()},
\code{\link{lbl_endpoints}()},
\code{\link{lbl_glue}()},
\code{\link{lbl_intervals}()},
\code{\link{lbl_manual}()},
\code{\link{lbl_midpoints}()},
\code{\link{lbl_seq}()}
}
\concept{labelling functions}
