% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conformal_infer_cv.R
\name{int_conformal_cv}
\alias{int_conformal_cv}
\alias{int_conformal_cv.default}
\alias{int_conformal_cv.resample_results}
\alias{int_conformal_cv.tune_results}
\title{Prediction intervals via conformal inference CV+}
\usage{
int_conformal_cv(object, ...)

\method{int_conformal_cv}{default}(object, ...)

\method{int_conformal_cv}{resample_results}(object, ...)

\method{int_conformal_cv}{tune_results}(object, parameters, ...)
}
\arguments{
\item{object}{An object from a tidymodels resampling or tuning function such
as \code{\link[tune:fit_resamples]{tune::fit_resamples()}}, \code{\link[tune:tune_grid]{tune::tune_grid()}}, or similar. The object
should have been produced in a way that the \code{.extracts} column contains the
fitted workflow for each resample (see the Details below).}

\item{...}{Not currently used.}

\item{parameters}{An tibble of tuning parameter values that can be
used to filter the predicted values before processing. This tibble should
select a single set of hyper-parameter values from the tuning results. This is
only required when a tuning object is passed to \code{object}.}
}
\value{
An object of class \code{"int_conformal_cv"} containing the information
to create intervals. The \code{predict()} method is used to produce the intervals.
}
\description{
Nonparametric prediction intervals can be computed for fitted regression
workflow objects using the CV+ conformal inference method described by
Barber \emph{at al} (2018).
}
\details{
This function implements the CV+ method found in Section 3 of Barber \emph{at al}
(2018). It uses the resampled model fits and their associated holdout
residuals to make prediction intervals for regression models.

This function prepares the objects for the computations. The \code{\link[=predict]{predict()}}
method computes the intervals for new data.

This method was developed for V-fold cross-validation (no repeats). Interval
coverage is unknown for any other resampling methods. The function will not
stop the computations for other types of resamples, but we have no way of
knowing whether the results are appropriate.
}
\examples{
\dontshow{if (!probably:::is_cran_check() & rlang::is_installed(c("modeldata", "parsnip"))) withAutoprint(\{ # examplesIf}
library(workflows)
library(dplyr)
library(parsnip)
library(rsample)
library(tune)
library(modeldata)

set.seed(2)
sim_train <- sim_regression(200)
sim_new <- sim_regression(5) |> select(-outcome)

sim_rs <- vfold_cv(sim_train)

# We'll use a neural network model
mlp_spec <-
  mlp(hidden_units = 5, penalty = 0.01) |>
  set_mode("regression")

# Use a control function that saves the predictions as well as the models.
# Consider using the butcher package in the extracts function to have smaller
# object sizes

ctrl <- control_resamples(save_pred = TRUE, extract = I)

set.seed(3)
nnet_res <-
  mlp_spec |>
  fit_resamples(outcome ~ ., resamples = sim_rs, control = ctrl)

nnet_int_obj <- int_conformal_cv(nnet_res)
nnet_int_obj

predict(nnet_int_obj, sim_new)
\dontshow{\}) # examplesIf}
}
\references{
Rina Foygel Barber, Emmanuel J. Candès, Aaditya Ramdas, Ryan J. Tibshirani
"Predictive inference with the jackknife+," \emph{The Annals of Statistics},
49(1), 486-507, 2021
}
\seealso{
\code{\link[=predict.int_conformal_cv]{predict.int_conformal_cv()}}
}
