% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{compare_maps}
\alias{compare_maps}
\title{Compare linkage maps, showing links between connecting markers common to neighbouring maps}
\usage{
compare_maps(
  maplist,
  chm.wd = 0.2,
  bg.col = "white",
  links.col = "grey42",
  thin.links = NULL,
  type = "karyotype",
  ...
)
}
\arguments{
\item{maplist}{A list of maps. This is probably most conveniently built on-the-fly in the function call itself.
If names are assigned to different maps (list items) these will appear above
the maps. In cases of multiple comparisons, for example comparing 1 map of interest to 3 others, the map of interest can
be supplied multiple times in the list, interspersed between the other maps. See the example below for details.}

\item{chm.wd}{The width in inches that linkage groups should be drawn. By default 0.2 inches is used.}

\item{bg.col}{The background colour of the maps, by default white. It can be useful to use a different background colour for the maps.
In this case, supply \code{bg.col} as a vector of colour identifiers, with the same length as \code{maplist} and corresponding to its elements in 
the same order. See the example below for details.}

\item{links.col}{The colour with which links between maps are drawn, by default grey.}

\item{thin.links}{Option to thin the plotting of links between maps, which might be useful if there are very many shared markers in a 
small genetic region. By default \code{NULL}, otherwise supply a value (in cM) for the minimum genetic distance between linking-lines 
(e.g. 0.5).}

\item{type}{Plot type, by default "karyotype". If "scatter" is requested a scatter plot is drawn, but only if the comparison is between 2 maps.}

\item{\dots}{option to supply arguments to the \code{plot} function (e.g. \code{main =} to add a title to the plot)}
}
\value{
\code{NULL}
}
\description{
This function allows the visualisation of connections between different maps, showing them side by side.
}
\examples{
data("map1","map2","map3")
compare_maps(maplist=list("1a"=map1,"c08"=map2,"1b"=map3),bg.col=c("thistle","white","skyblue"))
}
