% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_records.R
\name{get_records}
\alias{get_records}
\title{Retrieve species occurrence records within an Area of Interest}
\usage{
get_records(species, aoi_sf, providers = NULL,
  limit = 500, remove_duplicates = FALSE, date = NULL)
}
\arguments{
\item{species}{(`character`) Vector of species names to query.}

\item{aoi_sf}{(`sf`) An `sf` object representing the Area of Interest.
Must have a valid CRS.}

\item{providers}{(`character`) Data providers to query (e.g., `"gbif"`, `"inat"`).
Default is `NULL`, which queries all available providers.}

\item{limit}{(`integer`) Maximum number of records to retrieve per provider.
Default is 500.}

\item{remove_duplicates}{(`logical`) Whether to remove duplicate geometries.
Default is `FALSE`.}

\item{date}{(`character`) Vector of length two specifying the date range
(e.g., `c("YYYY-MM-DD", "YYYY-MM-DD")`). Records outside this range will
be excluded. Default is `NULL` (no date filtering).}
}
\value{
(`sf`) An `sf` object containing species occurrence records
  within the specified AOI that match the query criteria. Returns `NULL`
  if no records are found or if input parameters are invalid.
}
\description{
Retrieves species occurrence records from specified data providers
within a given Area of Interest (AOI). The results are returned as
an `sf` object containing point geometries. Duplicates can be removed
based on geometry. This is a wrapper of the `occ` function from the
\href{https://CRAN.R-project.org/package=spocc}{spocc package}.
}
\details{
This function simplifies retrieving occurrence records by wrapping the
functionality of the `spocc::occ` function. It handles AOI spatial
filtering and optional removal of duplicates.
}
\examples{
\donttest{
library(sf)
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"))
records <- get_records(
  species = "Lynx rufus",
  aoi_sf = nc,
  providers = c("gbif", "inat"),
  limit = 200
)
head(records)
}

}
