% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Burnet_Barr.r
\name{Burnett_Barr}
\alias{Burnett_Barr}
\title{Burnett and Barr Method for Nonparametric ANCOVA}
\usage{
Burnett_Barr(data, formula)
}
\arguments{
\item{data}{A data frame containing the variables specified in the formula.}

\item{formula}{An object of class "formula": a symbolic description of the 
model to be fitted. The structure should be `response ~ covariate + group`.}
}
\value{
A list containing the following components:
\describe{
  \item{regression_equation}{The summary of the fitted linear model.}
  \item{anova}{The ANOVA table from the fitted model.}
  \item{data}{The original data frame with added columns for ranks.}
}
}
\description{
Implements the Burnett and Barr rank-based method for ANCOVA. This method is
suitable for models with one response, one covariate, and one grouping variable.
}
\examples{
# 1. Create a sample data frame
data <- data.frame(
  group = c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3),
  response = c(16, 60, 82, 126, 137, 44, 67, 87, 100, 142, 17, 28, 105, 149, 160),
  covariate1 = c(26, 10, 42, 49, 55, 21, 28, 5, 12, 58, 1, 19, 41, 48, 35)
)

# 2. Run the Burnett and Barr method
results <- Burnett_Barr(
  formula = response ~ covariate1 + group,
  data = data
)

# 3. View the results
print(results)
print(results$anova)

}
\references{
Burnett TD, Barr DRJE, Measurement P. A nonparametric analogy of analysis of covariance. 1977;37(2):341-8.

Olejnik SF, Algina JJER. A review of nonparametric alternatives to analysis of covariance. 1985;9(1):51-83.
}
