% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_regression.R
\name{linear_regression}
\alias{linear_regression}
\title{Compute linear regression coefficients and errors.}
\usage{
linear_regression(x, x_err, y, y_err)
}
\arguments{
\item{x}{Required. vector of independent variables.}

\item{x_err}{Required. vector of independent variable errors.}

\item{y}{Required. Vector of dependent variables.}

\item{y_err}{Required. Vector of dependent variable errors.}
}
\value{
A data frame of linear regression slope, intercept, and associated errors
}
\description{
Given  x and y data compute simple linear regression slope and intercept, with errors by quadrature.
}
\examples{
y<- c(345,432,233)
y_err <- c(1,5,6)
x <- c(0.01,0.04,0.17)
x_err <- c(0.1,.3,.6)
linear_regression(x,x_err,y,y_err)
}
\author{
John Zobitz \email{zobitz@augsburg.edu}
}
