% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_flatline_test.R
\name{stat_flatline_test}
\alias{stat_flatline_test}
\title{Flat Line Test for Conservation Pattern}
\usage{
stat_flatline_test(phyex_set, ...)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object}

\item{...}{Additional arguments passed to stat_generic_conservation_test}
}
\value{
A test result object containing p-value and test statistics
}
\description{
Perform a flat line test to assess whether the transcriptomic index 
profile shows a flat (non-varying) pattern across developmental stages.
}
\details{
The flat line test evaluates whether the TXI profile remains constant across
developmental stages by testing the variance of the profile against a null
distribution. A significant result indicates rejection of the flat line pattern.
}
\examples{
# Perform flat line test
result <- stat_flatline_test(example_phyex_set)

}
\seealso{
\code{\link{stat_generic_conservation_test}}
}
