% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot-coord.R
\name{pivot_coord}
\alias{pivot_coord}
\title{Estimate pivot balance coordinates}
\usage{
pivot_coord(
  object,
  summary = TRUE,
  method = c("rotate", "refit"),
  parts = 1,
  ...
)
}
\arguments{
\item{object}{An object of class \code{brmcoda}.}

\item{summary}{Should summary statistics be returned instead of the raw values? Default is \code{TRUE}.}

\item{method}{A character string.
Should the pivot balance coordinates be estimated by \code{"rotate"} the sequential binary partition
using the same \code{brmcoda} object or \code{"refit"} the \code{brmcoda} object?
Default is \code{"rotate"}.}

\item{parts}{A optional character string specifying names of compositional parts that should be considered
in the substitution analysis. This should correspond to a single set of names of compositional parts specified
in the \code{complr} object. Default to the first composition in the \code{complr} object.}

\item{...}{Further arguments passed to \code{\link[brms:posterior_summary]{posterior_summary}}.}
}
\value{
Estimated pivot balance coordinates representing the
effect of increasing one compositional part relative to the remaining compositional parts.
}
\description{
This function estimates pivot balance coordinates for each compositional part by
either \code{"rotate"} the sequential binary partition using the same \code{brmcoda} object
or \code{"refit"} the \code{brmcoda} object.
}
\examples{
\donttest{
if(requireNamespace("cmdstanr")){
  x <- complr(data = mcompd, sbp = sbp,
                 parts = c("TST", "WAKE", "MVPA", "LPA", "SB"), idvar = "ID",
                 total = 1440)
  
  # inspects ILRs before passing to brmcoda
  names(x$between_logratio)
  names(x$within_logratio)
  names(x$logratio)
  
  # model with compositional predictor at between and within-person levels
  m <- brmcoda(complr = x,
                formula = Stress ~ bz1_1 + bz2_1 + bz3_1 + bz4_1 +
                                   wz1_1 + wz2_1 + wz3_1 + wz4_1 + (1 | ID),
                chain = 1, iter = 500,
                backend = "cmdstanr")
  
  m_pivot_coord <- pivot_coord(m)
  summary(m_pivot_coord)
  }}
}
