% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmult_sampling_mult.R
\name{mult_tsampling}
\alias{mult_tsampling}
\title{Samples From Truncated Dirichlet Density}
\usage{
mult_tsampling(
  inequalities,
  index = 1,
  niter = 10000,
  prior = FALSE,
  nburnin = niter * 0.05,
  seed = NULL
)
}
\arguments{
\item{inequalities}{list that contains inequality constraints for each independent inequality constrained hypotheses. The list
is created in the \code{\link{generate_restriction_list}} function}

\item{index}{numeric. If multiple independent inequality constraints are specified, this index determines for which
inequality constraint samples should be drawn. Must be a single value. Default is 1}

\item{niter}{numeric. A single value specifying the number of samples. Default is set to \eqn{10,000}}

\item{prior}{logical. If \code{TRUE} ignores the data that are encoded in \code{inequalities} and thus samples from the
prior distribution. Default is \code{FALSE}.}

\item{nburnin}{numeric. A single value specifying the number of burn-in samples when drawing from the truncated distribution.
Minimum number of burn-in samples is 10. Default is 5\% of the number of samples. Burn-in samples are removed automatically after the sampling.}

\item{seed}{numeric. Sets the seed for reproducible pseudo-random number generation}
}
\value{
matrix of dimension \code{niter * nsamples} containing prior or posterior samples from truncated Dirichlet distribution.
}
\description{
Based on specified inequality constraints, samples from truncated
prior or posterior Dirichlet density.
}
\details{
The model assumes that data follow a multinomial distribution and assigns a Dirichlet distribution as prior for the model parameters
(i.e., underlying category proportions). That is:
\deqn{x ~ Multinomial(N, \theta)}
\deqn{\theta ~ Dirichlet(\alpha)}
}
\note{
When equality constraints are specified in the restricted hypothesis, this function samples from the conditional
Dirichlet distribution given that the equality constraints hold.

Only inequality constrained parameters are sampled. Free parameters or parameters that are
exclusively equality constrained will be ignored.
}
\examples{
x <- c(200, 130, 40, 10)
a <- c(1, 1, 1, 1)
factor_levels <- c('mult1', 'mult2', 'mult3', 'mult4')
Hr <- c('mult1 > mult2 > mult3 > mult4')

# generate restriction list
inequalities <- generate_restriction_list(x=x, Hr=Hr, a=a, 
factor_levels=factor_levels)$inequality_constraints

# sample from prior distribution
prior_samples <- mult_tsampling(inequalities, niter = 500, prior=TRUE)
# sample from posterior distribution
post_samples <- mult_tsampling(inequalities, niter = 500)
}
\references{
\insertRef{damien2001sampling}{multibridge}

\insertRef{sarafoglou2020evaluatingPreprint}{multibridge}
}
\seealso{
\code{\link{generate_restriction_list}}
}
\concept{function to sample from truncated densities}
