% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.data.R
\name{write.data}
\alias{write.data}
\alias{write.data1}
\title{Write Data File in Table Format, SPSS, Excel, or Stata DTA File}
\usage{
write.data(x, file = "Data.csv", sep = ";", dec = ",", na = "",
           row.names = FALSE, col.names = TRUE, check = TRUE, ...)

write.data1(x, file = "Data.csv", sep = ",", dec = ".", na = "",
            row.names = FALSE, col.names = TRUE, check = TRUE, ...)
}
\arguments{
\item{x}{a matrix or data frame to be written.}

\item{file}{a character string indicating the name of the data file
with the file extension \code{.csv}, \code{.dat},
\code{.txt}, \code{.sav}, \code{.xlsx}, or \code{.dta}.
Note that the function will select an appropriate
\code{write}-function depending on the file extension.}

\item{sep}{a character string indicating the field separator, i.e.,
string for the delimiter. By default, the \code{write.data}
function uses a semicolon \code{";"}, while the function
\code{write.data1} function uses a comma \code{","} for
writing a CSV, DAT, or TXT data file}

\item{dec}{a character string indicating the decimal separator, i.e.,
string for decimal points. By default, the \code{write.data}
function uses a comma \code{","}, while the function
\code{write.data1} function uses a decimal point \code{"."}
for writing a CSV, DAT, or TXT data file.}

\item{na}{a character string to use for missing values in the data.
By default, a blank string \code{""} is used.}

\item{row.names}{logical: if \code{FALSE}, row names are written.}

\item{col.names}{logical: if \code{TRUE} (default), column names are written.}

\item{check}{logical: if \code{TRUE} (default), argument specification
is checked.}

\item{...}{additional arguments to pass to the \code{fwrite}
                 \code{\link{write.sav}}, \code{\link{write.xlsx}}, or
                 \code{\link{write.dta}} function, see \code{Arguments}
                 section in the help pages.}
}
\description{
This function writes a (1) data file in CSV (\code{.csv}), DAT (\code{.dat}),
or TXT (\code{.txt}) format using the \code{fwrite} function from the \pkg{data.table}
package, (2) SPSS file (\code{.sav}) using the \code{write.sav} function, (3)
Excel file (\code{.xlsx}) using the \code{write.xlsx} function, or a (4) Stata
DTA file (\code{.dta}) using the \code{write.dta} function in the \pkg{misty}
package. Note that the function \code{write.data} uses \code{","} for decimal
point and a semicolon \code{";"} for the separator, while the function
\code{write.data1} uses \code{"."} for decimal point and a comma \code{","}
for the separator when writing a CSV file.
}
\details{
\describe{
\item{\strong{Comma-Separated Values (CSV) File}}{The function \code{write.data}
writes CSV files based on the Excel convention for CSV files in some Western
European locales by default, i.e., \code{";"} as delimiter and \code{","} for
decimal points. Depending on the language setting of the operating system of
the computer, the arguments \code{sep} and \code{dec} need to be specified to
\code{","} and \code{"."} (see Example 1b). Alternatively, the function
\code{write.data1} that uses \code{","} as delimiter and \code{"."} for
decimal points by default can be used (see Example 1c).}
}}
\examples{
\dontrun{
# Example 1a: Write CSV data file, European format
write.data(mtcars, "European_CSV_Data.csv")

# Example 1b: Write CSV data file, American format
write.data(mtcars, "American_CSV_Data.csv", sep = ",", dec = ".")

# Example 1c: Write CSV data file, American format
write.data1(mtcars)

# Example 2: Write SPSS data file
write.data(mtcars, "SPSS_Data.sav")

# Example 3:  Write Excel data file
write.data(mtcars, "Excel_Data.xlsx")

# Example 4:  Write Stata data file
write.data(mtcars, "Stata_Data.dta")
}
}
\references{
Barrett, T., Dowle, M., Srinivasan, A., Gorecki, J., Chirico, M., Hocking, T.,
& Schwendinger, B. (2024). data.table: Extension of 'data.frame'. R package
version 1.16.0. \url{https://CRAN.R-project.org/package=data.table}

Jeroen O. (2021). \emph{writexl: Export Data Frames to Excel 'xlsx' Format}.
R package version 1.4.0. https://CRAN.R-project.org/package=writexl

Wickham H, Miller E, Smith D (2023). \emph{haven: Import and Export 'SPSS',
'Stata' and 'SAS' Files}. R package version 2.5.3.
\url{https://CRAN.R-project.org/package=haven}
}
\seealso{
\code{\link{read.data}}, \code{\link{read.sav}},
\code{\link{write.sav}}, \code{\link{write.xlsx}},
\code{\link{read.dta}}, \code{\link{write.dta}}, \code{\link{read.mplus}},
\code{\link{write.mplus}}
}
\author{
Takuya Yanagida
}
