% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{coffee_poly}
\alias{coffee_poly}
\title{World Coffee Production Data}
\format{
A tibble with 47 observations and 3 variables:
\describe{
  \item{name_long}{Country name (character)}
  \item{coffee_production_2016}{Coffee production in 2016, in thousands of 60 kg bags (integer)}
  \item{coffee_production_2017}{Coffee production in 2017, in thousands of 60 kg bags (integer)}
}
}
\source{
Data taken from the \pkg{spData} package version 2.3.4
}
\usage{
data(coffee_poly)
}
\description{
This dataset, \code{coffee_poly}, is a tibble containing estimates of global coffee production
by country. The data represent thousands of 60 kg bags of coffee produced in 2016 and 2017.
It is intended for teaching purposes only and not for research use.
}
\details{
The dataset consists of 47 observations (countries) and 3 variables, including the country name
and production values for two years. The data provide a simple example of tabular international
production figures that can be used in spatial and non-spatial analyses.

The dataset name has been kept as \code{coffee_poly} to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
\code{lightsf} package and assists users in identifying its specific characteristics.
The suffix \code{poly} indicates that the dataset can be linked to polygon boundaries for mapping.
The original content has not been modified in any way.
}
