% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptSynonyms.R
\name{reptSynonyms}
\alias{reptSynonyms}
\title{Retrieve Synonyms for Reptile Species from RDB}
\usage{
reptSynonyms(x, getRef = FALSE, showProgress = TRUE, cores = 1)
}
\arguments{
\item{x}{A character string with a species binomial or a data frame with columns \code{species} and \code{url}, typically the output of \code{\link{reptSpecies}} with \code{getLink = TRUE}.}

\item{getRef}{Logical. If \code{TRUE}, includes the reference(s) in which each synonym was mentioned. Default is \code{FALSE}.}

\item{showProgress}{Logical. If \code{TRUE}, prints data sampling progress. Default is \code{TRUE}.}

\item{cores}{Integer. Number of CPU cores to use for parallel processing. Default is \code{cores = 1}.}
}
\value{
A data frame with columns:
\itemize{
\item \code{species}: The valid species name according to RDB.
\item \code{synonym}: Recognized synonyms and chresonyms for the species. Chresonyms are usually separated from authors with an emdash.
\item \code{reference} (optional): If \code{getRef = TRUE}, the citation where the synonym was reported.
}
}
\description{
Retrieves a data frame containing the current valid names of reptile species along with all their recognized synonyms, as listed in The Reptile Database (RDB).
Optionally, the references citing each synonym can also be included.
}
\examples{
# Filter species belonging to genus Boa
boa <- letsRept::allReptiles[grep("^Boa\\\\s", letsRept::allReptiles$species), ]

\donttest{
# Retrieve synonyms (without references)
boa_syn <- reptSynonyms(boa, getRef = FALSE, cores = 2)
Bconstrictor_syn <- reptSynonyms(x = "Boa constrictor")
}

}
\references{
Uetz, P., Freed, P., Aguilar, R., Reyes, F., Kudera, J., & Hošek, J. (eds.) (2025). The Reptile Database. Retrieved from \url{http://www.reptile-database.org}
}
\seealso{
\code{\link{reptSpecies}}, \code{\link{reptAdvancedSearch}}
}
