% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cross_loadings.R
\name{add_cross_loadings}
\alias{add_cross_loadings}
\title{Adds (Substantial) Cross-loadings to \code{\link[latentFactoR]{simulate_factors}} Data}
\usage{
add_cross_loadings(
  lf_object,
  proportion_cross_loadings,
  proportion_cross_loadings_range = NULL,
  magnitude_cross_loadings,
  magnitude_cross_loadings_range = NULL,
  leave_cross_loadings = FALSE
)
}
\arguments{
\item{lf_object}{Data object from \code{\link[latentFactoR]{simulate_factors}}}

\item{proportion_cross_loadings}{Numeric (length = 1 or \code{factors}).
Proportion of variables that should be cross-loaded randomly onto
one other factor. Accepts number of variables to 
cross-load onto one other factor as well}

\item{proportion_cross_loadings_range}{Numeric (length = 2).
Range of proportion of variables that should be cross-loaded randomly onto
one other factor. Accepts number of variables to 
cross-load onto one other factor as well}

\item{magnitude_cross_loadings}{Numeric (length = 1, \code{factors}, or total number of variables to cross-load across all factors).
The magnitude or size of the cross-loadings.
Must range between \code{-1} and \code{1}.}

\item{magnitude_cross_loadings_range}{Numeric (length = 2).
The range of the magnitude or size of the cross-loadings.
Defaults to \code{NULL}}

\item{leave_cross_loadings}{Boolean.
Should cross-loadings be kept?
Defaults to \code{FALSE}.
Convergence problems can arise if cross-loadings are kept,
so setting them to zero is the default. Only set to \code{TRUE}
with careful consideration of the structure. Make sure to perform
additional checks that the data are adequate}
}
\value{
Returns a list containing the same parameters as the original
\code{lf_object} but with updated \code{data}, \code{population_correlation},
and \code{parameters} (specifically, \code{loadings} matrix). Also returns
original \code{lf_object} in \code{original_results}
}
\description{
Intended to add substantial cross-loadings to simulated data from \code{\link[latentFactoR]{simulate_factors}}. 
See examples to get started
}
\examples{
# Generate factor data
two_factor <- simulate_factors(
  factors = 2, # factors = 2
  variables = 6, # variables per factor = 6
  loadings = 0.55, # loadings between = 0.45 to 0.65
  cross_loadings = 0.05, # cross-loadings N(0, 0.05)
  correlations = 0.30, # correlation between factors = 0.30
  sample_size = 1000 # number of cases = 1000
)

# Add substantial cross-loadings
two_factor_CL <- add_cross_loadings(
  lf_object = two_factor,
  proportion_cross_loadings = 0.25,
  magnitude_cross_loadings = 0.35
)

# Randomly vary proportions
two_factor_CL <- add_cross_loadings(
  lf_object = two_factor,
  proportion_cross_loadings_range = c(0, 0.25),
  magnitude_cross_loadings = 0.35
)

# Randomly vary magnitudes
two_factor_CL <- add_cross_loadings(
  lf_object = two_factor,
  proportion_cross_loadings = 0.25,
  magnitude_cross_loadings_range = c(0.35, 0.45)
)

# Set number of cross-loadings per factor (rather than proportion)
two_factor_CL <- add_cross_loadings(
  lf_object = two_factor,
  proportion_cross_loadings = 2,
  magnitude_cross_loadings = 0.35
)

}
\references{
Christensen, A. P., Garrido, L. E., & Golino, H. (2022).
Unique variable analysis: A network psychometrics method to detect local dependence.
\emph{PsyArXiv}
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>,
Hudson Golino <hfg9s@virginia.edu>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu>
}
