% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lang-use.R
\name{lang_use}
\alias{lang_use}
\title{Specifies the LLM provider and model to use during the R session}
\usage{
lang_use(
  backend = NULL,
  model = NULL,
  .cache = NULL,
  .lang = NULL,
  .silent = FALSE,
  ...
)
}
\arguments{
\item{backend}{"ollama" or an \code{ellmer} \code{Chat} object. If using "ollama",
\code{mall} will use is out-of-the-box integration with that back-end. Defaults
to "ollama".}

\item{model}{The name of model supported by the back-end provider}

\item{.cache}{The path to save model results, so they can be re-used if
the same operation is ran again. To turn off, set this argument to an empty
character: \code{""}. It defaults to a temp folder. If this argument is left
\code{NULL} when calling this function, no changes to the path will be made.}

\item{.lang}{Target language to translate to. This will override values found
in the LANG and LANGUAGE environment variables.}

\item{.silent}{Boolean flag that controls if there is or not output to the
console. Defaults to FALSE.}

\item{...}{Additional arguments that this function will pass down to the
integrating function. In the case of Ollama, it will pass those arguments to
\code{ollamar::chat()}.}
}
\value{
Console output of the current LLM setup to be used during the
R session.
}
\description{
Allows us to specify the back-end provider, model to use during the current
R session. The target language is not processed by the function, as in
converting "english" to "en" for example. The value is passed directly to
the LLM, and it lets the LLM interpret the target language.
}
\examples{
\donttest{
library(lang)

# Using an `ellmer` chat object
lang_use(ellmer::chat_openai(model = "gpt-4o"))

# Using Ollama directly
lang_use("ollama", "llama3.2", seed = 100)

# Turn off cache by setting `.cache` to ""
lang_use("ollama", "llama3.2", seed = 100, .cache = "")

# Use `.lang` to set the target language to translate to,
# it will be set for the current R session
lang_use("ollama", "llama3.2", .lang = "spanish")

# Use `.silent` to avoid console output
lang_use("ollama", "llama3.2", .lang = "spanish", .silent = TRUE)

# To see current settings, simply call the function
lang_use()
}

}
