% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gee.R
\name{geeExp}
\alias{geeExp}
\title{geeExp: transform the unit of coefficients (internal function)}
\usage{
geeExp(gee.coef, family = "binomial", dec)
}
\arguments{
\item{gee.coef}{geeUni object.}

\item{family}{Family: "gaussian", "binomial", "poisson", "quasipoisson", etc..., Default: 'binomial'}

\item{dec}{Decimal point}
}
\value{
The transforemed coefficients(95% CI), p-value
}
\description{
Transform the unit of coefficients to "Coeff", "OR" or "RR"
}
\details{
DETAILS
}
\examples{
library(geepack)
data(dietox)
dietox$Cu <- as.factor(dietox$Cu)
gee.uni <- geeUni("Weight", c("Time", "Cu"),
  data = dietox, id.vec = dietox$Pig,
  family = "gaussian", cor.type = "exchangeable"
)
gee.exp <- geeExp(gee.uni, "binomial", 2)
}
