% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSubstitutions.R
\name{getSubstitutions}
\alias{getSubstitutions}
\title{Return a dataframe that contains all line-up changes for a set of given
match IDs}
\usage{
getSubstitutions(matches, token, host = "https://api.impect.com")
}
\arguments{
\item{matches}{'IMPECT' match ID or a list of match IDs}

\item{token}{bearer token}

\item{host}{host environment}
}
\value{
a dataframe containing all line-up changes for a set of given
match IDs
}
\description{
Return a dataframe that contains all line-up changes for a set of given
match IDs
}
\examples{
# Toy example: this will error quickly (no API token)
try(subs <- getSubstitutions(
  matches = c(0, 1),
  token = "invalid"
))

# Real usage: requires valid Bearer Token from `getAccessToken()`
\dontrun{
subs <- getSubstitutions(
  matches = c(84248, 158150),
  token = "yourToken"
)
}
}
