% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morePlots.R
\name{cond_moment_plot}
\alias{cond_moment_plot}
\title{Conditional mean or variance plot for a GMVAR, StMVAR, or G-StMVAR model}
\usage{
cond_moment_plot(
  gsmvar,
  which_moment = c("mean", "variance"),
  grid = FALSE,
  ...
)
}
\arguments{
\item{gsmvar}{an object of class \code{'gsmvar'}, typically created with \code{fitGSMVAR} or \code{GSMVAR}.}

\item{which_moment}{should conditional means or variances be plotted?}

\item{grid}{add grid to the plots?}

\item{...}{additional paramters passed to \code{grid(...)} plotting the grid if \code{grid == TRUE}.}
}
\description{
\code{cond_moment_plot} plots the one-step in-sample conditional means/variances of the model along with
 the individual time series contained in the model (e.g. the time series the model was fitted to). Also plots
 the regimewise conditional means/variances multiplied with mixing weights.
}
\details{
The conditional mean plot works best if the data contains positive values only.
 \code{acf} from the package \code{stats} and the plot method for class \code{'acf'} objects is employed.
}
\examples{
# GMVAR(2, 2), d=2 model;
params22 <- c(0.36, 0.121, 0.223, 0.059, -0.151, 0.395, 0.406, -0.005,
 0.083, 0.299, 0.215, 0.002, 0.03, 0.484, 0.072, 0.218, 0.02, -0.119,
 0.722, 0.093, 0.032, 0.044, 0.191, 1.101, -0.004, 0.105, 0.58)
mod22 <- GSMVAR(gdpdef, p=2, M=2, params=params22)
cond_moment_plot(mod22, which_moment="mean")
cond_moment_plot(mod22, which_moment="variance")
cond_moment_plot(mod22, which_moment="mean", grid=TRUE, lty=3)

# G-StMVAR(2, 1, 1), d=2 model:
params22gs <- c(0.697, 0.154, 0.049, 0.374, 0.476, 0.318, -0.645, -0.302,
 -0.222, 0.193, 0.042, -0.013, 0.048, 0.554, 0.033, 0.184, 0.005, -0.186,
  0.683, 0.256, 0.031, 0.026, 0.204, 0.583, -0.002, 0.048, 0.182, 4.334)
mod22gs <- GSMVAR(gdpdef, p=2, M=c(1, 1), params=params22gs, model="G-StMVAR")
cond_moment_plot(mod22gs, which_moment="mean")
cond_moment_plot(mod22gs, which_moment="variance")

#StMVAR(4, 1), d=2 model:
params41t <- c(0.512, -0.002, 0.243, 0.024, -0.088, 0.452, 0.242, 0.011,
  0.093, 0.162, -0.097, 0.033, -0.339, 0.19, 0.091, 0.006, 0.168, 0.101,
  0.516, -0.005, 0.054, 4.417)
mod41t <- GSMVAR(gdpdef, p=4, M=1, params=params41t, model="StMVAR")
cond_moment_plot(mod41t, which_moment="mean")
cond_moment_plot(mod41t, which_moment="variance")
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Lütkepohl H. 2005. New Introduction to Multiple Time Series Analysis,
         \emph{Springer}.
   \item McElroy T. 2017. Computation of vector ARMA autocovariances.
         \emph{Statistics and Probability Letters}, \strong{124}, 92-96.
   \item Virolainen S. 2025. A statistically identified structural vector autoregression with endogenously
          switching volatility regime. \emph{Journal of Business & Economic Statistics}. \strong{43}:1, 44-54.
   \item Virolainen S. in press. A Gaussian and Student’s mixture vector autoregressive model with an application
    to monetary policy shocks. Econometrics and Statistics.
 }
}
\seealso{
\code{\link{profile_logliks}}, \code{\link{fitGSMVAR}}, \code{\link{GSMVAR}},
 \code{\link{quantile_residual_tests}}, \code{\link{LR_test}}, \code{\link{Wald_test}},
 \code{\link{diagnostic_plot}}
}
