% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-stack-.R
\name{position_stack_}
\alias{position_stack_}
\alias{position_fill_}
\title{Stack overlapping objects on top of each another}
\usage{
position_stack_(vjust = 1, reverse = FALSE)

position_fill_(vjust = 1, reverse = FALSE)
}
\arguments{
\item{vjust}{Vertical adjustment for geoms that have a position
(like points or lines), not a dimension (like bars or areas). Set to
\code{0} to align with the bottom, \code{0.5} for the middle,
and \code{1} (the default) for the top.}

\item{reverse}{If \code{TRUE}, will reverse the default stacking order.
This is useful if you're rotating both the plot and legend.}
}
\description{
\code{position_stack_} stacks bars on top of each other, conditional on locations.
}
\details{
It is built based on \code{\link[ggplot2]{position_stack}}, but used for multiple locations, such as
\code{\link{geom_hist_}} or \code{\link{geom_density_}}. Rather than stack everything on top of each other,
\code{position_stack_} stacks bars based on locations.
Check examples to see the difference.
}
\examples{
p <- ggplot(iris,
       mapping = aes(Sepal.Length = Sepal.Length,
                     Sepal.Width = Sepal.Width,
                     Petal.Length = Petal.Length,
                     Petal.Width = Petal.Width,
                     colour = Species))
p +
 geom_serialaxes_density(position = position_stack_())

\donttest{
p +
  geom_serialaxes_density(position = position_stack())
}

}
\seealso{
See \code{\link{geom_hist_}}, \code{\link{geom_density_}},
\code{\link{geom_serialaxes_density}} and \code{\link{geom_serialaxes_hist}} for more examples.

Other position adjustments for multiple locations:
\code{\link{position_identity_}},
\code{\link{position_dodge_}}, \code{\link{position_dodge2_}}

Parent: \code{\link[ggplot2]{position_stack}}
}
