% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{LungCancer}
\alias{LungCancer}
\title{NCCTG Lung Cancer Marker Data}
\format{
{This is a data frame with 238 observations and the following 4 variables.
   \describe{
   \item{id  }{health institutions code}

   \item{time }{time to death in days}


   \item{status }{censoring indicator; 1=censored, 2=dead}

   \item{marker }{risk score derived from the observed data using frailty model}
   }
   }
}
\usage{
data(LungCancer)
}
\description{
This dataset contains four columns: \code{id}, the identifier for health institutions (clusters); \code{marker}, the risk score; \code{time}, the observed follow-up time; and \code{status}, the event indicator for subjects in the NCCTG lung cancer marker dataset.
}
\details{
{
   \describe{
         The NCCTG lung cancer dataset was collected from 228 patients across 18 different healthcare institutions.
         The number of subjects per institution ranged from 2 to 36. For the final analysis, only 226 patients with
         complete records were included. The dataset contains survival times along with several important predictor
         variables, including: sex (coded as Male = 1, Female = 2), age (in years), ph.ecog (Eastern Cooperative
         Oncology Group performance status, assessed by a physician on a scale from 0 [asymptomatic] to 5 [dead]),
         and pat.karno (Karnofsky performance status, assessed by the patient).

         The marker (risk score) was derived from three predictor variables: sex, age, and ph.ecog. To this end,
         a frailty model with gamma-distributed frailty was fitted. As in the previous example, the prognostic marker is defined as:
\deqn{\hat{\nu} \exp(\hat{\beta}_1 \cdot \text{sex} + \hat{\beta}_2 \cdot \text{age} + \hat{\beta}_3 \cdot \text{ph.ecog})}

where \eqn{\hat{\nu}} is the estimated frailty term, and \eqn{\hat{\beta}_i}(for \code{i=}1,2,3) are
the estimated regression coefficients from the frailty model.}
}
}
\references{
Beyene, K. M., and Chen, D. G. (2024). Time-dependent receiver operating characteristic curve estimator for correlated right-censored time-to-event data. \emph{Statistical Methods in Medical Research}, 33(1), 162-181.
}
\keyword{datasets}
