% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{autoplot.comp_bayes_lm}
\alias{autoplot.comp_bayes_lm}
\title{Plot Bayesian model parameters}
\usage{
\method{autoplot}{comp_bayes_lm}(object, type = "intercepts", sp_to_plot = NULL, ...)
}
\arguments{
\item{object}{Output of \code{\link{comp_bayes_lm}}}

\item{type}{A single character string for plot type with possible values
"intercepts", "dbh_slopes", or "competition".}

\item{sp_to_plot}{Vector of subset of species to plot}

\item{...}{Currently ignored—only included for consistency with generic.}
}
\value{
\code{focal_vs_comp} with new column of predicted \code{growth_hat}
}
\description{
Plot Bayesian model parameters
}
\examples{
library(ggplot2)
library(ggridges)

# Load in posterior parameter example
data(comp_bayes_lm_ex)

# Plot beta_0, growth intercepts
autoplot(comp_bayes_lm_ex, type = "intercepts")

# Plot beta_dbh, growth-dbh slope
autoplot(comp_bayes_lm_ex, type = "dbh_slopes")

# Plot lambdas, competition coefficients
autoplot(comp_bayes_lm_ex, type = "competition")
}
