% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_flow_time.R
\name{filter_flow_time}
\alias{filter_flow_time}
\alias{filter_flow_time.log}
\alias{filter_flow_time.grouped_log}
\alias{ifilter_flow_time}
\title{Filter directly follows with time interval}
\usage{
filter_flow_time(
  log,
  from,
  to,
  interval,
  reverse = FALSE,
  units = c("secs", "mins", "hours", "days", "weeks")
)

\method{filter_flow_time}{log}(
  log,
  from,
  to,
  interval,
  reverse = FALSE,
  units = c("secs", "mins", "hours", "days", "weeks")
)

\method{filter_flow_time}{grouped_log}(
  log,
  from,
  to,
  interval,
  reverse = FALSE,
  units = c("secs", "mins", "hours", "days", "weeks")
)

ifilter_flow_time(log)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{from, to}{\code{\link{character}} vector of length 1: The antecendent and consequent to filter on. Both are \code{\link{character}}
vectors containing exactly one activity identifier.}

\item{interval}{\code{\link{numeric}} vector of length 2: A duration interval. Half open interval can be created using \code{\link{NA}}.}

\item{reverse}{\code{\link{logical}} (default \code{FALSE}): Indicating whether the selection should be reversed.}

\item{units}{\code{\link{character}} (default \code{"secs"}): The time unit in which the processing times should be reported. Should be one of the following values:
\code{"secs"} (default), \code{"mins"}, \code{"hours"}, \code{"days"}, \code{"weeks"}. See also the \code{units} argument of \code{\link[=difftime]{difftime()}}.}
}
\value{
When given an object of type \code{\link[bupaR]{log}}, it will return a filtered \code{\link[bupaR]{log}}.
When given an object of type \code{\link[bupaR]{grouped_log}}, the filter will be applied in a stratified way (i.e. each separately for each group).
The returned log will be grouped on the same variables as the original log.
}
\description{
Filter cases where the activity \code{from} is followed by activity \code{to} within a certain time \code{interval}.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_flow_time(log)}: Filters on flow time for a \code{\link[bupaR:log]{bupaR::log}}.

\item \code{filter_flow_time(grouped_log)}: Filters on flow time for a \code{\link[bupaR:grouped_log]{bupaR::grouped_log}}.

}}
\section{Functions}{
\itemize{
\item \code{ifilter_flow_time()}: Filter interactively

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
\code{\link[=processing_time]{processing_time()}},\code{\link[=difftime]{difftime()}}

Other filters: 
\code{\link{filter_activity}()},
\code{\link{filter_activity_frequency}()},
\code{\link{filter_activity_instance}()},
\code{\link{filter_activity_presence}()},
\code{\link{filter_case}()},
\code{\link{filter_case_condition}()},
\code{\link{filter_endpoints}()},
\code{\link{filter_endpoints_condition}()},
\code{\link{filter_idle_time}()},
\code{\link{filter_infrequent_flows}()},
\code{\link{filter_lifecycle}()},
\code{\link{filter_lifecycle_presence}()},
\code{\link{filter_precedence}()},
\code{\link{filter_precedence_condition}()},
\code{\link{filter_precedence_resource}()},
\code{\link{filter_processing_time}()},
\code{\link{filter_resource}()},
\code{\link{filter_resource_frequency}()},
\code{\link{filter_throughput_time}()},
\code{\link{filter_time_period}()},
\code{\link{filter_trace}()},
\code{\link{filter_trace_frequency}()},
\code{\link{filter_trace_length}()},
\code{\link{filter_trim}()},
\code{\link{filter_trim_lifecycle}()}
}
\concept{filters}
\concept{filters_case}
