% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaiserCriterion.R
\name{kaiserCrit}
\alias{kaiserCrit}
\title{Selecting the number of principal components to be extracted from a dataset}
\usage{
kaiserCrit(data)
}
\arguments{
\item{data}{Units x variables data matrix.}
}
\value{
\item{bestQ}{Number of components to be extracted (scalar).}
}
\description{
Selects the optimal number of principal components to be extracted from a dataset based on Kaiser's criterion
}
\examples{
# Iris data 
# Loading the numeric variables of iris data
iris <- scale(as.matrix(iris[,-5])) 

# Apply the Kaiser rule
h <- kaiserCrit(iris)

}
\references{
Kaiser H. F. (1960) "The Application of Electronic Computers to Factor Analysis" <doi:10.1177/001316446002000>
}
\author{
Ionel Prunila, Maurizio Vichi
}
