% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomp_disease.R
\name{decomp_disease}
\alias{decomp_disease}
\title{Title decomp_disease}
\usage{
decomp_disease(
  df,
  breakdown,
  diseases,
  age_col,
  group_1,
  group_1_m,
  group_2,
  group_2_m,
  nDx
)
}
\arguments{
\item{df}{An outputted life table with relevant columns of interest}

\item{breakdown}{Whether disease breakdowns are raw mortality rates or a decimal proportion of total all-cause mortality rate. Accepts either 'proportion' or 'raw'.}

\item{diseases}{Character vector of diseases which are suffixed to \code{group_1} and \code{group_2}, and found in both groups. There should be no other characters after these diseases for the function to capture the group-disease combinations.}

\item{age_col}{Column providing ordered age bands with the final age group being an open-ended interval suffxied with '+', e.g. '90+'.. Of factor type.}

\item{group_1}{Unique matching stem prefix in columns for group 1 related disease cause breakdowns}

\item{group_1_m}{Column name for group 1 all-cause mortality rate between ages x and x + n}

\item{group_2}{Unique matching stem prefix in columns for group 2 related disease cause breakdowns}

\item{group_2_m}{Column name for group 2 all-cause mortality rate between ages x and x + n}

\item{nDx}{Column name for contribution of all-cause mortality differences in groups 1 and 2 in age groups x to x + n. Computationally the same as the total effect column computed from \code{decomp_LE()}.}
}
\value{
A data frame with attached life expectancy disease breakdown decomposition values
}
\description{
Function for performing life expectancy decomposition for disease groups
}
