% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_svm.R
\name{reg_svm}
\alias{reg_svm}
\title{SVM for regression}
\usage{
reg_svm(attribute, epsilon = 0.1, cost = 10, kernel = "radial")
}
\arguments{
\item{attribute}{attribute target to model building}

\item{epsilon}{parameter that controls the width of the margin around the separating hyperplane}

\item{cost}{parameter that controls the trade-off between having a wide margin and correctly classifying training data points}

\item{kernel}{the type of kernel function to be used in the SVM algorithm (linear, radial, polynomial, sigmoid)}
}
\value{
returns a SVM regression object
}
\description{
Support Vector Regression (SVR) using \code{e1071::svm}.
}
\details{
SVR optimizes a margin with an epsilon‑insensitive loss around the regression function.
The \code{cost} controls regularization strength; \code{epsilon} sets the width of the insensitive tube; and
\code{kernel} defines the feature map (linear, radial, polynomial, sigmoid).
}
\examples{
data(Boston)
model <- reg_svm("medv", epsilon=0.2,cost=40.000)

# preparing dataset for random sampling
sr <- sample_random()
sr <- train_test(sr, Boston)
train <- sr$train
test <- sr$test

model <- fit(model, train)

test_prediction <- predict(model, test)
test_predictand <- test[,"medv"]
test_eval <- evaluate(model, test_predictand, test_prediction)
test_eval$metrics
}
\references{
Drucker, H., Burges, C., Kaufman, L., Smola, A., Vapnik, V. (1997). Support Vector Regression Machines.
Chang, C.-C. and Lin, C.-J. (2011). LIBSVM: A library for support vector machines.
}
