% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forward.R
\name{noisy_or}
\alias{noisy_or}
\title{Calculating the probability of transition from multiple nodes to given node in the dag}
\usage{
noisy_or(hmm, prev_state, cur_state)
}
\arguments{
\item{hmm}{Object of class List given as output by \code{\link{initHMM}},}

\item{prev_state}{vector containing state variable values for the previous nodes}

\item{cur_state}{character denoting the state variable value for current node}
}
\value{
The Noisy_OR probability for the transition
}
\description{
Calculating the probability of transition from multiple nodes to given node in the dag
}
\examples{

library(bnlearn)

tmat = matrix(c(0,0,1,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0),
               5,5, byrow= TRUE ) #for "X" (5 nodes) shaped dag
states = c("P","N") #"P" represent cases(or positive) and "N" represent controls(or negative)
bnet = model2network("[A][C|A:B][D|A:C][B|A]") #A is the target variable while
                                               #B, C and D are covariates.
obsvA=data.frame(list(B=c("L","H","H","L","L"),C=c("H","H","L","L","H"),D=c("L","L","L","H","H")))
hmmA = initHMM(States=states, dagmat= tmat, net=bnet, observation=obsvA)
Transprob = noisy_or(hmm=hmmA,prev_state=c("P","N"),cur_state="P") #for transition from P & N
                                                                   #simultaneously to P
}
