% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baumWelch.R
\name{baumWelchRecursion}
\alias{baumWelchRecursion}
\title{Implementation of the Baum Welch Algorithm as a special case of EM algorithm}
\usage{
baumWelchRecursion(hmm, observation, t_seq, kn_states = NULL, kn_verify = NULL)
}
\arguments{
\item{hmm}{hmm Object of class List given as output by \code{\link{initHMM}}}

\item{observation}{Dataframe containing the discritized character values of only covariates at each node. Column names of dataframe should be same as the covariate names. Missing values should be denoted by "NA".}

\item{t_seq}{list of forward and backward DAG traversal sequence (in that order) as given output by \code{\link{fwd_seq_gen}} and \code{\link{bwd_seq_gen}} function}

\item{kn_states}{(Optional) A (L * 2) dataframe where L is the number of training nodes where state values are known. First column should be the node number and the second column being the corresponding known state values of the nodes}

\item{kn_verify}{(Optional) A (L * 2) dataframe where L is the number of validation nodes where state values are known. First column should be the node number and the second column being the corresponding known state values of the nodes}
}
\value{
List containing estimated Transition and Emission probability matrices
}
\description{
\code{\link{baumWelch}} recursively calls this function to give a final estimate of parameters for dag HMM
Uses Parallel Processing to speed up calculations for large data. Should not be used directly.
}
\examples{

library(bnlearn)

tmat = matrix(c(0,0,1,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0),
               5,5, byrow= TRUE ) #for "X" (5 nodes) shaped dag
states = c("P","N") #"P" represent cases(or positive) and "N" represent controls(or negative)
bnet = model2network("[A][C|A:B][D|A:C][B|A]") #A is the target variable while
                                               #B, C and D are covariates
obsvA=data.frame(list(B=c("L","H","H","L","L"),C=c("H","H","L","L","H"),D=c("L","L","L","H","H")))
hmmA = initHMM(States=states, dagmat= tmat, net=bnet, observation=obsvA)
kn_st = data.frame(node=c(2),state=c("P"),stringsAsFactors = FALSE)
                   #state at node 2 is known to be "P"
kn_vr = data.frame(node=c(3,4,5),state=c("P","N","P"),stringsAsFactors = FALSE)
                   #state at node 3,4,5 are "P","N","P" respectively
t_seq=list(fwd_seq_gen(hmmA),bwd_seq_gen(hmmA))
newparam= baumWelchRecursion(hmm=hmmA,observation=obsvA,t_seq=t_seq,
                             kn_states=kn_st, kn_verify=kn_vr)
}
\seealso{
\code{\link{baumWelch}}
}
