with_mock_dir("exposure-batch",{

test_that("DTXSID errors", {
  expect_error(get_exposure_functional_use_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_exposure_functional_use_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_exposure_functional_use_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
  expect_error(get_exposure_functional_use_probability_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_exposure_functional_use_probability_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_exposure_functional_use_probability_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
  expect_error(get_httk_data_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_httk_data_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_httk_data_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
  expect_error(get_exposure_product_data_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_exposure_product_data_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_exposure_product_data_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
  expect_error(get_exposure_list_presence_tags_by_dtxsid_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_exposure_list_presence_tags_by_dtxsid_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_exposure_list_presence_tags_by_dtxsid_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
  expect_error(get_general_exposure_prediction_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_general_exposure_prediction_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_general_exposure_prediction_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
  expect_error(get_demographic_exposure_prediction_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_demographic_exposure_prediction_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_demographic_exposure_prediction_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')

  expect_error(get_single_sample_records_by_dtxsid_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_single_sample_records_by_dtxsid_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_single_sample_records_by_dtxsid_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
  expect_error(get_aggregate_records_by_dtxsid_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_aggregate_records_by_dtxsid_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_aggregate_records_by_dtxsid_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
  expect_error(get_single_sample_records_by_medium_batch(Medium = 1, API_key = 'test_key'), 'Please input a character list for Medium!')
  expect_error(get_single_sample_records_by_medium_batch(Medium = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for Medium!')
  expect_error(get_single_sample_records_by_medium_batch(API_key = 'test_key'), 'Please input a list of Media!')
  expect_error(get_aggregate_records_by_medium_batch(Medium = 1, API_key = 'test_key'), 'Please input a character list for Medium!')
  expect_error(get_aggregate_records_by_medium_batch(Medium = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for Medium!')
  expect_error(get_aggregate_records_by_medium_batch(API_key = 'test_key'), 'Please input a list of Media!')
  expect_error(get_product_use_categories_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_product_use_categories_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_product_use_categories_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
  expect_error(get_production_volume_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_production_volume_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_production_volume_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
  expect_error(get_biomonitoring_data_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_biomonitoring_data_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_biomonitoring_data_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
  expect_error(get_general_use_keywords_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_general_use_keywords_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_general_use_keywords_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
  expect_error(get_reported_functional_use_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_reported_functional_use_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_reported_functional_use_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
  expect_error(get_chemical_weight_fraction_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_chemical_weight_fraction_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_chemical_weight_fraction_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
})

test_that("Rate limit warnings", {
  expect_warning(get_exposure_functional_use_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_exposure_functional_use_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_exposure_functional_use_probability_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_exposure_functional_use_probability_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_httk_data_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_httk_data_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_exposure_product_data_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_exposure_product_data_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_exposure_list_presence_tags_by_dtxsid_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_exposure_list_presence_tags_by_dtxsid_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_general_exposure_prediction_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_general_exposure_prediction_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_demographic_exposure_prediction_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_demographic_exposure_prediction_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
})

test_that("Return data type", {
  expect_type(get_exposure_functional_use_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key()), 'list')
  expect_type(get_exposure_functional_use_batch(DTXSID = c(''), API_key = ctx_key()), 'list')
  expect_type(get_exposure_functional_use_probability_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key()), 'list')
  expect_type(get_exposure_functional_use_probability_batch(DTXSID = c(''), API_key = ctx_key()), 'list')
  expect_type(get_httk_data_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key()), 'list')
  expect_type(get_httk_data_batch(DTXSID = c(''), API_key = ctx_key()), 'list')
  expect_type(get_exposure_product_data_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key()), 'list')
  expect_type(get_exposure_product_data_batch(DTXSID = c(''), API_key = ctx_key()), 'list')
  expect_type(get_exposure_list_presence_tags_by_dtxsid_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key()), 'list')
  expect_type(get_exposure_list_presence_tags_by_dtxsid_batch(DTXSID = c(''), API_key = ctx_key()), 'list')
  expect_type(get_general_exposure_prediction_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key()), 'list')
  expect_type(get_general_exposure_prediction_batch(DTXSID = c(''), API_key = ctx_key()), 'list')
  expect_type(get_demographic_exposure_prediction_batch(DTXSID = c('DTXSID7020182'), API_key = ctx_key()), 'list')
  expect_type(get_demographic_exposure_prediction_batch(DTXSID = c(''), API_key = ctx_key()), 'list')
  #expect_type(get_single_sample_records_by_dtxsid_batch(DTXSID = 'DTXSID0020232', API_key = ctx_key()), 'list')
  expect_type(get_single_sample_records_by_dtxsid_batch(DTXSID = '', API_key = ctx_key()), 'list')
  expect_type(get_aggregate_records_by_dtxsid_batch(DTXSID = 'DTXSID0020232', API_key = ctx_key()), 'list')
  expect_type(get_aggregate_records_by_dtxsid_batch(DTXSID = '', API_key = ctx_key()), 'list')
  expect_type(get_single_sample_records_by_medium_batch(Medium = '', API_key = ctx_key()), 'list')
  expect_type(get_aggregate_records_by_medium_batch(Medium = '', API_key = ctx_key()), 'list')
  expect_type(get_product_use_categories_batch(DTXSID = 'DTXSID0020232', API_key = ctx_key()), 'list')
  expect_type(get_product_use_categories_batch(DTXSID = '', API_key = ctx_key()), 'list')
  expect_type(get_production_volume_batch(DTXSID = 'DTXSID7020182', API_key = ctx_key()), 'list')
  expect_type(get_production_volume_batch(DTXSID = '', API_key = ctx_key()), 'list')
  expect_type(get_biomonitoring_data_batch(DTXSID = 'DTXSID7020182', API_key = ctx_key()), 'list')
  expect_type(get_biomonitoring_data_batch(DTXSID = '', API_key = ctx_key()), 'list')
  expect_type(get_general_use_keywords_batch(DTXSID = 'DTXSID7020182', API_key = ctx_key()), 'list')
  expect_type(get_general_use_keywords_batch(DTXSID = '', API_key = ctx_key()), 'list')
  expect_type(get_reported_functional_use_batch(DTXSID = 'DTXSID7020182', API_key = ctx_key()), 'list')
  expect_type(get_reported_functional_use_batch(DTXSID = '', API_key = ctx_key()), 'list')
  expect_type(get_chemical_weight_fraction_batch(DTXSID = 'DTXSID7020182', API_key = ctx_key()), 'list')
  expect_type(get_chemical_weight_fraction_batch(DTXSID = '', API_key = ctx_key()), 'list')

})})
