% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure-APIs.R
\name{get_single_sample_records_by_dtxsid}
\alias{get_single_sample_records_by_dtxsid}
\title{Get single sample records by DTXSID}
\usage{
get_single_sample_records_by_dtxsid(
  DTXSID = NULL,
  API_key = NULL,
  Server = "https://comptox.epa.gov/ctx-api/exposure",
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some "progress report" should be given.}
}
\value{
A data.frame of single sample record data by DTXSID.
}
\description{
Get single sample records by DTXSID
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
#Pull single sample records for BPA by DTXSID
bpa_sample_records <- get_single_sample_records_by_dtxsid(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
