% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioactivity-APIs-batch.R
\name{get_bioactivity_details_batch}
\alias{get_bioactivity_details_batch}
\title{Retrieve bioactivity data from DTXSID or AEID batch}
\usage{
get_bioactivity_details_batch(
  DTXSID = NULL,
  AEID = NULL,
  SPID = NULL,
  m4id = NULL,
  API_key = NULL,
  Server = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{A list of chemical identifier DTXSIDs.}

\item{AEID}{A list of assay endpoint identifiers AEIDs.}

\item{SPID}{A list of ChemSpider chemical inputs}

\item{m4id}{A list of chemical identifier m4ids}

\item{API_key}{The user-specific API key.}

\item{Server}{The root address for the API endpoint}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of data.frames containing bioactivity information for
the chemicals with DTXSID or assays with AEID matching the input parameter.
}
\description{
Retrieve bioactivity data from DTXSID or AEID batch
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull bioactivity details for multiple chemicals
dtxsid <- c('DTXSID7020182', 'DTXSID2021315')
batch_bioactivity <- get_bioactivity_details_batch(DTXSID = dtxsid)
# Pull bioactivity details for multiple assays
batch_bioactivity <- get_bioactivity_details_batch(AEID = c(159, 160))
\dontshow{\}) # examplesIf}
}
