% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts_treatment.R
\name{treatment_code}
\alias{treatment_code}
\title{Use treatment coding}
\usage{
treatment_code(n)
}
\arguments{
\item{n}{Integer umber of factor levels to compute contrasts for.}
}
\value{
A contrast matrix with dimensions n rows and (n-1) columns.
}
\description{
Wrapper around \code{\link[stats:contrast]{stats::contr.treatment()}}. Returns a contrast
matrix where comparisons give differences between each comparison level and a
baseline reference level, while the intercept equals the first level of the
factor. See \code{\link[=scaled_sum_code]{scaled_sum_code()}} for a function that centers
the intercept on the grand mean while retaining pairwise comparisons from a
reference level.
}
\details{
For n levels of factors, generate a matrix with n-1 comparisons
where:
\itemize{
\item Reference level = 0
\item Comparison level = 1
\item All others = 0
}

Note that this function sets the first level (alphabetically) as the
reference level while  \code{\link[stats:contrast]{stats::contr.SAS()}} sets the LAST level as the
reference level. However, in functions like
\code{\link[=set_contrasts]{set_contrasts()}}, and \code{\link[=enlist_contrasts]{enlist_contrasts()}}, the reference level is
automatically set to be the first level alphabetically.
}
\examples{
mydf <- data.frame(
  grp = gl(4,5),
  resp = c(seq(1, 5), seq(5, 9), seq(10, 14), seq(15, 19))
)

mydf <- set_contrasts(mydf, grp ~ treatment_code)

lm(resp ~ grp, data = mydf)

}
