\name{wat1_pediatric_score}
\alias{wat1_pediatric_score}
\title{
Withdrawal Assessment Tool - 1 (WAT-1) for Pediatric Withdrawal
}
\description{
Calculates the WAT-1 score to assess withdrawal symptoms in pediatric patients (typically in the PICU) who are being weaned from opioids or benzodiazepines. The scale includes an assessment of records (past 12 hours), a 2-minute pre-stimulus observation, and a stimulus-recovery assessment.
}
\usage{
wat1_pediatric_score(loose_stools, vomiting_retching, temperature_gt_37_8,
                     tremor, sweating, uncoordinated_movements, yawning_sneezing,
                     startle_to_touch, muscle_tone, time_to_calm, agitation_state)
}
\arguments{
  \item{loose_stools}{
Numeric (0 or 1). Any loose/watery stools in the last 12 hours? (1 = Yes).
}
  \item{vomiting_retching}{
Numeric (0 or 1). Any vomiting or retching in the last 12 hours? (1 = Yes).
}
  \item{temperature_gt_37_8}{
Numeric (0 or 1). Temperature > 37.8 C in the last 12 hours? (1 = Yes).
}
  \item{tremor}{
Numeric (0 or 1). Moderate to severe tremor observed during the 2-minute pre-stimulus observation? (1 = Yes).
}
  \item{sweating}{
Numeric (0 or 1). Any sweating observed during the 2-minute pre-stimulus observation? (1 = Yes).
}
  \item{uncoordinated_movements}{
Numeric (0 or 1). Uncoordinated or repetitive movements observed during the 2-minute pre-stimulus observation? (1 = Yes).
}
  \item{yawning_sneezing}{
Numeric (0 or 1). Yawning or sneezing (>1 time) observed during the 2-minute pre-stimulus observation? (1 = Yes).
}
  \item{startle_to_touch}{
Numeric (0 or 1). Moderate to severe startle response to tactile stimulus? (1 = Yes).
}
  \item{muscle_tone}{
Numeric (0 or 1). Increased muscle tone during stimulus? (1 = Yes).
}
  \item{time_to_calm}{
Numeric (0 or 1). Time to calm down after stimulus > 2-5 minutes? (1 = Yes).
}
  \item{agitation_state}{
Numeric (0 or 1). Patient state during the 2-minute observation. (0 = Calm/Asleep/Awake and distressed <2 mins, 1 = Awake and distressed >= 2 mins). Note: Scoring guides may vary slightly on "State" definition but generally, sustained distress adds 1 point.
}
}
\value{
A list containing:
\item{WAT1_Score}{The calculated total score (Range 0-11 or 0-12 depending on agitation weight implementation, typically 0-11).}
\item{Interpretation}{Clinical interpretation (Score >= 3 indicates significant withdrawal).}
}
\references{
Franck LS, Harris SK, Soetenga DJ, Amling JK, Curley MA. The Withdrawal Assessment Tool-1 (WAT-1): an assessment instrument for monitoring opioid and benzodiazepine withdrawal in pediatric patients. Pediatr Crit Care Med. 2008;9(6):573-580. doi:10.1097/PCC.0b013e31818c84bd
}
\examples{

# Example 1: Significant Withdrawal
# Fever, Tremor, Sweating, Agitated
wat1_pediatric_score(0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1)

# Example 2: No Withdrawal
# No symptoms
wat1_pediatric_score(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
}
