\name{sedan_score_hemorrhage}
\alias{sedan_score_hemorrhage}
\title{
SEDAN Score for Post-tPA Hemorrhage Risk
}
\description{
Calculates the SEDAN score to estimate the risk of symptomatic intracranial hemorrhage (sICH) in patients with acute ischemic stroke treated with intravenous tissue plasminogen activator (tPA). The score is derived from: Sugar (glucose), Early infarct signs, Dense cerebral artery sign, Age, and NIHSS.
}
\usage{
sedan_score_hemorrhage(glucose, early_infarct_signs, hyperdense_artery_sign,
                       age, nihss_score, glucose_units = "mmol/L")
}
\arguments{
  \item{glucose}{
Numeric. Baseline blood glucose level.
}
  \item{early_infarct_signs}{
Numeric (0 or 1). Presence of early infarct signs on initial CT scan. (1 = Yes, +1 point).
}
  \item{hyperdense_artery_sign}{
Numeric (0 or 1). Presence of hyperdense cerebral artery sign on initial CT scan. (1 = Yes, +1 point).
}
  \item{age}{
Numeric. Patient age in years. (> 75 years adds 1 point).
}
  \item{nihss_score}{
Numeric. Baseline NIH Stroke Scale score. (>= 10 adds 1 point).
}
  \item{glucose_units}{
String. Units for glucose input. Options: "mmol/L" (default) or "mg/dL".
Scoring:
<= 8.0 mmol/L (144 mg/dL): 0 pts
8.1 - 12.0 mmol/L (145-216 mg/dL): 1 pt
> 12.0 mmol/L (216 mg/dL): 2 pts
}
}
\value{
A list containing:
\item{SEDAN_Score}{The calculated total score (Range 0-6).}
\item{Risk_sICH}{The estimated percentage risk of symptomatic intracranial hemorrhage.}
\item{Risk_Category}{General risk classification.}
}
\references{
Strbian D, Engelter S, Michel P, et al. Symptomatic intracranial hemorrhage after stroke thrombolysis: the SEDAN score. Ann Neurol. 2012;71(5):634-641. doi:10.1002/ana.23546
}
\examples{
# Example 1: High Risk
# Glucose 250 mg/dL (>12 mmol/L -> 2 pts), Age 80 (+1), NIHSS 15 (+1)
# Score = 4
sedan_score_hemorrhage(250, 0, 0, 80, 15, "mg/dL")

# Example 2: Low Risk
# Glucose 5.5 mmol/L, Age 60, NIHSS 5, No CT signs
# Score = 0
sedan_score_hemorrhage(5.5, 0, 0, 60, 5)
}
