\name{rhd_immune_globulin_dosage}
\alias{rhd_immune_globulin_dosage}
\title{
Rh Immune Globulin Dosage for Fetomaternal Hemorrhage
}
\description{
Calculates the required dosage of Rho(D) immune globulin (RhoGAM) in vials following a significant Fetomaternal Hemorrhage (FMH) based on the Kleihauer-Betke Stain (KBS) result. This dosage is critical for preventing RhD alloimmunization in RhD-negative mothers.
}
\usage{
rhd_immune_globulin_dosage(kbs_fetal_cells_per_5000, maternal_blood_volume_ml = 5000)
}
\arguments{
  \item{kbs_fetal_cells_per_5000}{
Numeric. The number of fetal cells counted per 5000 maternal cells on the Kleihauer-Betke Stain.
}
  \item{maternal_blood_volume_ml}{
Numeric. Estimated maternal blood volume in milliliters. Defaults to 5000 mL (5 Liters) for standard adult calculations.
}
}
\details{
The calculation determines the volume of fetal blood in the maternal circulation, which is then used to calculate the required number of RhoGAM vials. One standard dose of RhoGAM covers 30 mL of fetal whole blood. The result is rounded up, and one extra vial is added as a safety margin.
}
\value{
A list containing:
\item{Fetal_Blood_Volume_mL}{The estimated volume of fetal whole blood in the maternal circulation.}
\item{RhoGAM_Vials_Calculated}{The total number of RhoGAM vials recommended (calculated dose rounded up + 1 extra vial).}
}
\references{
ACOG Practice Bulletin No. 192: Prevention of Rh D Alloimmunization. Obstet Gynecol. 2018;131(3):e57-e73. doi:10.1097/AOG.0000000000002521
}
\examples{

# Example 1: Large Hemorrhage
# 100 fetal cells per 5000 maternal cells (Ratio 1:50)
# Fetal volume = (100/5000) * 5000 = 100 mL
# Vials needed = ceil(100/30) + 1 = 4 + 1 = 5 vials
rhd_immune_globulin_dosage(100)

# Example 2: Small Hemorrhage
# 15 fetal cells per 5000 maternal cells
rhd_immune_globulin_dosage(15)
}
