\name{qsofa_sepsis_score}
\alias{qsofa_sepsis_score}
\title{
quick SOFA (qSOFA) Score for Sepsis
}
\description{
Calculates the quick Sequential Organ Failure Assessment (qSOFA) score. This bedside tool identifies patients with suspected infection who are at greater risk for a poor outcome (prolonged ICU stay or in-hospital mortality) outside the intensive care unit. It uses three clinical criteria: respiratory rate, altered mental status, and systolic blood pressure.
}
\usage{
qsofa_sepsis_score(respiratory_rate, systolic_bp, gcs_score)
}
\arguments{
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute. (>= 22 adds 1 point).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg. (<= 100 adds 1 point).
}
  \item{gcs_score}{
Numeric. Glasgow Coma Scale score (3-15). (Any score < 15 indicates altered mental status and adds 1 point).
}
}
\value{
A list containing:
\item{qSOFA_Score}{The calculated score (Range 0-3).}
\item{Risk_Category}{"High Risk" if Score >= 2, otherwise "Low Risk".}
\item{Interpretation}{Clinical guidance based on the risk level.}
}
\references{
Singer M, Deutschman CS, Seymour CW, et al. The Third International Consensus Definitions for Sepsis and Septic Shock (Sepsis-3). JAMA. 2016;315(8):801-810. doi:10.1001/jama.2016.0287
}
\examples{

# Example 1: High Risk Sepsis
# RR 24 (+1), SBP 95 (+1), GCS 14 (+1)
# Score = 3
qsofa_sepsis_score(24, 95, 14)

# Example 2: Low Risk
# RR 18, SBP 120, GCS 15
# Score = 0
qsofa_sepsis_score(18, 120, 15)
}
