\name{pediatric_nexus_ii_head_ct}
\alias{pediatric_nexus_ii_head_ct}
\title{
Pediatric NEXUS II Head CT Decision Instrument
}
\description{
Calculates the Pediatric NEXUS II result to determine the necessity of a head CT scan in children with blunt head trauma. The rule identifies patients at low risk for clinically important intracranial injury who may be safely managed without imaging. If any of the seven criteria are present, imaging is generally indicated.
}
\usage{
pediatric_nexus_ii_head_ct(skull_fracture_evidence, scalp_hematoma,
                           neurologic_deficit, altered_alertness,
                           abnormal_behavior, coagulopathy, persistent_vomiting)
}
\arguments{
  \item{skull_fracture_evidence}{
Numeric (0 or 1). Evidence of significant skull fracture (e.g., palpable depression, basilar signs). (1 = Yes).
}
  \item{scalp_hematoma}{
Numeric (0 or 1). Presence of scalp hematoma. (1 = Yes).
}
  \item{neurologic_deficit}{
Numeric (0 or 1). Presence of neurologic deficit. (1 = Yes).
}
  \item{altered_alertness}{
Numeric (0 or 1). Altered level of alertness (GCS < 15). (1 = Yes).
}
  \item{abnormal_behavior}{
Numeric (0 or 1). Abnormal behavior present (e.g., agitation, somnolence, refusal to eat). (1 = Yes).
}
  \item{coagulopathy}{
Numeric (0 or 1). Presence of coagulopathy (history of bleeding disorder or anticoagulation). (1 = Yes).
}
  \item{persistent_vomiting}{
Numeric (0 or 1). Persistent vomiting. (1 = Yes).
}
}
\value{
A list containing:
\item{Result}{Recommendation regarding the need for Head CT ("Indicated" or "Not Indicated").}
\item{Inputs}{A summary of the criteria evaluated.}
}
\references{
Mower WR, Hoffman JR, Herbert M, et al. Developing a decision instrument to guide computed tomographic imaging of blunt head injury patients. J Trauma. 2005;59(4):954-959.
}
\examples{

# Example 1: Low Risk
# No findings
pediatric_nexus_ii_head_ct(0, 0, 0, 0, 0, 0, 0)

# Example 2: CT Indicated (Hematoma)
# Scalp hematoma present
pediatric_nexus_ii_head_ct(0, 1, 0, 0, 0, 0, 0)
}
